/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.converter;

import com.vaadin.data.util.converter.Converter;
import de.mhus.lib.core.MCast;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateConverter
implements Converter<String, Date> {
    private static final long serialVersionUID = 1L;

    public Date convertToModel(String value, Class<? extends Date> targetType, Locale locale) throws Converter.ConversionException {
        return MCast.toDate((Object)value, null);
    }

    public String convertToPresentation(Date value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null || value.getTime() == 0L) {
            return "-";
        }
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("dd.MM.yyyy hh:mm:ss a");
        return df.format(value.getTime());
    }

    public Class<Date> getModelType() {
        return Date.class;
    }

    public Class<String> getPresentationType() {
        return String.class;
    }
}

