/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.container;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.AbstractInMemoryContainer;
import com.vaadin.data.util.ItemSorter;
import com.vaadin.data.util.MethodProperty;
import com.vaadin.data.util.VaadinPropertyDescriptor;
import com.vaadin.data.util.filter.SimpleStringFilter;
import com.vaadin.data.util.filter.UnsupportedFilterException;
import de.mhus.lib.vaadin.container.MhuBeanItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class MhuAbstractBeanContainer<IDTYPE, BEANTYPE>
extends AbstractInMemoryContainer<IDTYPE, String, MhuBeanItem<BEANTYPE>>
implements Container.Filterable,
Container.SimpleFilterable,
Container.Sortable,
Property.ValueChangeListener,
Container.PropertySetChangeNotifier {
    private BeanIdResolver<IDTYPE, BEANTYPE> beanIdResolver = null;
    private final Map<IDTYPE, MhuBeanItem<BEANTYPE>> itemIdToItem = new HashMap<IDTYPE, MhuBeanItem<BEANTYPE>>();
    private final Class<? super BEANTYPE> type;
    protected LinkedHashMap<String, MhuBeanItem.PojoPropertyDescriptor<BEANTYPE>> model;

    protected MhuAbstractBeanContainer(Class<? super BEANTYPE> type) {
        if (type == null) {
            throw new IllegalArgumentException("The bean type passed to AbstractBeanContainer must not be null");
        }
        this.type = type;
        this.model = MhuBeanItem.getPropertyDescriptors(type);
    }

    public Class<?> getType(Object propertyId) {
        return this.model.get(propertyId).getPropertyType();
    }

    protected MhuBeanItem<BEANTYPE> createBeanItem(BEANTYPE bean) {
        return bean == null ? null : new MhuBeanItem<BEANTYPE>(bean, this.model);
    }

    public Class<? super BEANTYPE> getBeanType() {
        return this.type;
    }

    public Collection<String> getContainerPropertyIds() {
        return this.model.keySet();
    }

    public boolean removeAllItems() {
        int origSize = this.size();
        this.internalRemoveAllItems();
        for (Item item : this.itemIdToItem.values()) {
            this.removeAllValueChangeListeners(item);
        }
        this.itemIdToItem.clear();
        if (origSize != 0) {
            this.fireItemSetChange();
        }
        return true;
    }

    public MhuBeanItem<BEANTYPE> getItem(Object itemId) {
        return this.getUnfilteredItem(itemId);
    }

    protected MhuBeanItem<BEANTYPE> getUnfilteredItem(Object itemId) {
        return this.itemIdToItem.get(itemId);
    }

    public List<IDTYPE> getItemIds() {
        return super.getItemIds();
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        MhuBeanItem<BEANTYPE> item = this.getItem(itemId);
        if (item == null) {
            return null;
        }
        return item.getItemProperty(propertyId);
    }

    public boolean removeItem(Object itemId) {
        int origSize = this.size();
        MhuBeanItem<BEANTYPE> item = this.getItem(itemId);
        int position = this.indexOfId(itemId);
        if (this.internalRemoveItem(itemId)) {
            this.removeAllValueChangeListeners((Item)item);
            this.itemIdToItem.remove(itemId);
            if (this.size() != origSize) {
                this.fireItemRemoved(position, itemId);
            }
            return true;
        }
        return false;
    }

    public void valueChange(Property.ValueChangeEvent event) {
        this.filterAll();
    }

    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        try {
            this.addFilter((Container.Filter)new SimpleStringFilter(propertyId, filterString, ignoreCase, onlyMatchPrefix));
        }
        catch (UnsupportedFilterException e) {
            // empty catch block
        }
    }

    public void removeAllContainerFilters() {
        if (!this.getFilters().isEmpty()) {
            for (Item item : this.itemIdToItem.values()) {
                this.removeAllValueChangeListeners(item);
            }
            this.removeAllFilters();
        }
    }

    public void removeContainerFilters(Object propertyId) {
        Collection removedFilters = super.removeFilters(propertyId);
        if (!removedFilters.isEmpty()) {
            for (Item item : this.itemIdToItem.values()) {
                this.removeValueChangeListener(item, propertyId);
            }
        }
    }

    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.addFilter(filter);
    }

    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(filter);
    }

    public boolean hasContainerFilters() {
        return super.hasContainerFilters();
    }

    public Collection<Container.Filter> getContainerFilters() {
        return super.getContainerFilters();
    }

    private void addValueChangeListener(Item item, Object propertyId) {
        Property property = item.getItemProperty(propertyId);
        if (property instanceof Property.ValueChangeNotifier) {
            Property.ValueChangeNotifier notifier = (Property.ValueChangeNotifier)property;
            notifier.removeListener((Property.ValueChangeListener)this);
            notifier.addListener((Property.ValueChangeListener)this);
        }
    }

    private void removeValueChangeListener(Item item, Object propertyId) {
        Property property = item.getItemProperty(propertyId);
        if (property instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)property).removeListener((Property.ValueChangeListener)this);
        }
    }

    private void removeAllValueChangeListeners(Item item) {
        for (Object propertyId : item.getItemPropertyIds()) {
            this.removeValueChangeListener(item, propertyId);
        }
    }

    public Collection<?> getSortableContainerPropertyIds() {
        return this.getSortablePropertyIds();
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        this.sortContainer(propertyId, ascending);
    }

    public ItemSorter getItemSorter() {
        return super.getItemSorter();
    }

    public void setItemSorter(ItemSorter itemSorter) {
        super.setItemSorter(itemSorter);
    }

    protected void registerNewItem(int position, IDTYPE itemId, MhuBeanItem<BEANTYPE> item) {
        this.itemIdToItem.put(itemId, item);
        for (Container.Filter filter : this.getFilters()) {
            for (String propertyId : this.getContainerPropertyIds()) {
                if (!filter.appliesToProperty((Object)propertyId)) continue;
                this.addValueChangeListener((Item)item, propertyId);
            }
        }
    }

    private boolean validateBean(BEANTYPE bean) {
        return bean != null && this.getBeanType().isAssignableFrom(bean.getClass());
    }

    protected MhuBeanItem<BEANTYPE> addItem(IDTYPE itemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return (MhuBeanItem)this.internalAddItemAtEnd(itemId, (Item)this.createBeanItem(bean), true);
    }

    protected MhuBeanItem<BEANTYPE> addItemAfter(IDTYPE previousItemId, IDTYPE newItemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return (MhuBeanItem)this.internalAddItemAfter(previousItemId, newItemId, (Item)this.createBeanItem(bean), true);
    }

    protected MhuBeanItem<BEANTYPE> addItemAt(int index, IDTYPE newItemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return (MhuBeanItem)this.internalAddItemAt(index, newItemId, (Item)this.createBeanItem(bean), true);
    }

    protected MhuBeanItem<BEANTYPE> addBean(BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItem(itemId, bean);
    }

    protected MhuBeanItem<BEANTYPE> addBeanAfter(IDTYPE previousItemId, BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItemAfter(previousItemId, itemId, bean);
    }

    protected MhuBeanItem<BEANTYPE> addBeanAt(int index, BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItemAt(index, itemId, bean);
    }

    protected void addAll(Collection<? extends BEANTYPE> collection) throws IllegalStateException, IllegalArgumentException {
        boolean modified = false;
        for (BEANTYPE bean : collection) {
            if (bean == null || !this.getBeanType().isAssignableFrom(bean.getClass())) continue;
            IDTYPE itemId = this.resolveBeanId(bean);
            if (itemId == null) {
                throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
            }
            if (this.internalAddItemAtEnd(itemId, (Item)this.createBeanItem(bean), false) == null) continue;
            modified = true;
        }
        if (modified) {
            if (this.isFiltered()) {
                this.filterAll();
            } else {
                this.fireItemSetChange();
            }
        }
    }

    protected IDTYPE resolveBeanId(BEANTYPE bean) {
        if (this.beanIdResolver == null) {
            throw new IllegalStateException("Bean item identifier resolver is required.");
        }
        return this.beanIdResolver.getIdForBean(bean);
    }

    protected void setBeanIdResolver(BeanIdResolver<IDTYPE, BEANTYPE> beanIdResolver) {
        this.beanIdResolver = beanIdResolver;
    }

    public BeanIdResolver<IDTYPE, BEANTYPE> getBeanIdResolver() {
        return this.beanIdResolver;
    }

    protected BeanIdResolver<IDTYPE, BEANTYPE> createBeanPropertyResolver(Object propertyId) {
        return new PropertyBasedBeanIdResolver(propertyId);
    }

    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.addPropertySetChangeListener(listener);
    }

    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.removePropertySetChangeListener(listener);
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use addNestedContainerProperty(String) to add container properties to a " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    protected boolean mergeAll(Collection<? extends BEANTYPE> collection, boolean removeOverlapping, Comparator<IDTYPE> comparator) throws IllegalStateException, IllegalArgumentException {
        boolean modified = false;
        LinkedList negativeList = null;
        if (removeOverlapping) {
            negativeList = new LinkedList();
            negativeList.addAll(this.getAllItemIds());
        }
        for (BEANTYPE bean : collection) {
            IDTYPE itemId;
            if (bean == null || (itemId = this.resolveBeanId(bean)) == null) continue;
            if (negativeList != null) {
                negativeList.remove(itemId);
            }
            if (comparator != null) {
                for (Object id : this.getAllItemIds()) {
                    if (comparator.compare(id, itemId) != 0) continue;
                }
            } else if (this.getAllItemIds().contains(itemId)) continue;
            if (this.internalAddItemAtEnd(itemId, (Item)this.createBeanItem(bean), false) == null) continue;
            modified = true;
        }
        if (negativeList != null && negativeList.size() > 0) {
            modified = true;
            for (Object id : negativeList) {
                this.removeItem(id);
            }
        }
        if (modified) {
            if (this.isFiltered()) {
                this.filterAll();
            } else {
                this.fireItemSetChange();
            }
        }
        return modified;
    }

    protected class PropertyBasedBeanIdResolver
    implements BeanIdResolver<IDTYPE, BEANTYPE> {
        private final Object propertyId;

        public PropertyBasedBeanIdResolver(Object propertyId) {
            if (propertyId == null) {
                throw new IllegalArgumentException("Property identifier must not be null");
            }
            this.propertyId = propertyId;
        }

        @Override
        public IDTYPE getIdForBean(BEANTYPE bean) throws IllegalArgumentException {
            VaadinPropertyDescriptor pd = MhuAbstractBeanContainer.this.model.get(this.propertyId);
            if (null == pd) {
                throw new IllegalStateException("Property " + this.propertyId + " not found");
            }
            try {
                Property property = pd.createProperty(bean);
                return property.getValue();
            }
            catch (MethodProperty.MethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static interface BeanIdResolver<IDTYPE, BEANTYPE>
    extends Serializable {
        public IDTYPE getIdForBean(BEANTYPE var1);
    }
}

