/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.aqua;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.vaadin.aqua.DesktopView;
import de.mhus.lib.vaadin.aqua.HelpManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Desktop
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private Navigator nav;
    private CssLayout content;
    private CssLayout menu;
    private Connector connector;
    private MNls nls;
    private MenuBar.MenuItem settingsMenu;
    private MenuBar.Command settingsMenuCmd;
    private HelpManager helpManager;
    LinkedList<ViewDefinition> views = new LinkedList();
    HashMap<String, ViewDefinition> currentViews = new HashMap();

    public void initUI() {
        String defName;
        ViewDefinition def;
        if (this.nav != null) {
            return;
        }
        this.helpManager = new HelpManager(this.getUI());
        this.content = new CssLayout();
        this.nav = new Navigator(this.getUI(), (ComponentContainer)this.content);
        this.addComponent((Component)this.content);
        this.content.setSizeFull();
        this.content.addStyleName("view-content");
        this.setExpandRatio((Component)this.content, 1.0f);
        this.menu = new CssLayout();
        this.addComponent((Component)new HorizontalLayout(){
            private static final long serialVersionUID = 1L;
            {
                this.setSizeFull();
                this.addStyleName("main-view");
                this.addComponent((Component)new VerticalLayout(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.addStyleName("sidebar");
                        this.setWidth(null);
                        this.setHeight("100%");
                        this.addComponent((Component)new CssLayout(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.addStyleName("branding");
                                Label logo = new Label("<span>" + MNls.find((MNls)Desktop.this.nls, (String)"appname1=") + "</span><br/>" + MNls.find((MNls)Desktop.this.nls, (String)"appname2="), ContentMode.HTML);
                                logo.setSizeUndefined();
                                this.addComponent((Component)logo);
                            }
                        });
                        this.addComponent((Component)Desktop.this.menu);
                        this.setExpandRatio((Component)Desktop.this.menu, 1.0f);
                        this.addComponent((Component)new VerticalLayout(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.setSizeUndefined();
                                this.addStyleName("user");
                                Image profilePic = new Image(null, (Resource)new ThemeResource("img/profile-pic.png"));
                                profilePic.setWidth("34px");
                                this.addComponent((Component)profilePic);
                                Label userName = new Label(Desktop.this.connector.getUserName());
                                userName.setSizeUndefined();
                                this.addComponent((Component)userName);
                                Desktop.this.settingsMenuCmd = new MenuBar.Command(){
                                    private static final long serialVersionUID = 1L;

                                    public void menuSelected(MenuBar.MenuItem selectedItem) {
                                        Desktop.this.connector.doSettingsMenuAction(selectedItem);
                                    }
                                };
                                MenuBar settings = new MenuBar();
                                Desktop.this.settingsMenu = settings.addItem("", null);
                                Desktop.this.settingsMenu.setStyleName("icon-cog");
                                Desktop.this.doUpdateSettingsMenu();
                                this.addComponent((Component)settings);
                                NativeButton exit = new NativeButton("Exit");
                                exit.addStyleName("icon-cancel");
                                exit.setDescription(MNls.find((MNls)Desktop.this.nls, (String)"logout=Sign Out"));
                                this.addComponent((Component)exit);
                                exit.addClickListener(new Button.ClickListener(){
                                    private static final long serialVersionUID = 1L;

                                    public void buttonClick(Button.ClickEvent event) {
                                        Desktop.this.connector.doLogout();
                                    }
                                });
                            }
                        });
                    }
                });
                this.addComponent((Component)Desktop.this.content);
                Desktop.this.content.setSizeFull();
                Desktop.this.content.addStyleName("view-content");
                this.setExpandRatio((Component)Desktop.this.content, 1.0f);
            }
        });
        this.menu.removeAllComponents();
        this.menu.addStyleName("menu");
        this.menu.setHeight("100%");
        this.doUpdateStructure();
        String f = Page.getCurrent().getUriFragment();
        if (f == null) {
            f = "";
        }
        if (f.startsWith("!")) {
            f = f.substring(1);
        }
        if ((def = this.getDefinition(defName = f.length() < 1 ? f : MString.beforeIndex((String)f.substring(1), (char)'/'))) == null || f.equals("") || f.equals("/")) {
            defName = this.connector.getDefaultViewName();
            def = this.getDefinition(defName);
        }
        if (def != null) {
            this.nav.navigateTo("/" + defName);
            def.b.addStyleName("selected");
            def.showHelp(this.helpManager);
        }
        this.nav.addViewChangeListener(new ViewChangeListener(){
            private static final long serialVersionUID = 1L;

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                Desktop.this.helpManager.closeAll();
                if (event.getNewView() instanceof DesktopView) {
                    ((DesktopView)event.getNewView()).doInitWithDesktop(Desktop.this, event.getParameters());
                }
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                String n = event.getViewName();
                String defName = MString.beforeIndex((String)n.substring(1), (char)'/');
                ViewDefinition def = Desktop.this.getDefinition(defName);
                if (def != null) {
                    def.showHelp(Desktop.this.helpManager);
                }
            }
        });
        this.doUpdateSettingsMenu();
    }

    public void doUpdateSettingsMenu() {
        this.settingsMenu.removeChildren();
        List<String> list = this.connector.getSettingsMenuCaptions();
        if (list == null) {
            return;
        }
        for (String caption : list) {
            if (caption.equals("-")) {
                this.settingsMenu.addSeparator();
                continue;
            }
            this.settingsMenu.addItem(caption, this.settingsMenuCmd);
        }
    }

    public void doUpdateStructure() {
        for (String name : this.currentViews.keySet()) {
            this.nav.removeView(name);
        }
        this.currentViews.clear();
        this.menu.removeAllComponents();
        for (final ViewDefinition def : this.views) {
            this.currentViews.put(def.getName(), def);
            if (def.getView() == null) {
                this.nav.addView("/" + def.getName(), def.getViewClass());
            } else {
                this.nav.addView("/" + def.getName(), def.getView());
            }
            NativeButton b = new NativeButton(def.getCaption());
            def.setNavButton((Button)b);
            if (def.getIconName() != null) {
                b.addStyleName("icon-" + def.getIconName());
            }
            b.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    Desktop.this.clearMenuSelection();
                    event.getButton().addStyleName("selected");
                    if (!Desktop.this.nav.getState().equals("/" + def.getName())) {
                        Desktop.this.nav.navigateTo("/" + def.getName());
                    }
                }
            });
            b.setHtmlContentAllowed(true);
            def.updateCaption();
            this.menu.addComponent((Component)b);
        }
    }

    private void clearMenuSelection() {
        Iterator it = this.menu.getComponentIterator();
        while (it.hasNext()) {
            Component next = (Component)it.next();
            if (next instanceof NativeButton) {
                next.removeStyleName("selected");
                continue;
            }
            if (!(next instanceof DragAndDropWrapper)) continue;
            ((Component)((DragAndDropWrapper)next).iterator().next()).removeStyleName("selected");
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public MNls getNls() {
        return this.nls;
    }

    public void setNls(MNls nls) {
        this.nls = nls;
    }

    public ViewDefinition getDefinition(String name) {
        ViewDefinition ret = this.currentViews.get(name);
        if (ret == null) {
            for (ViewDefinition def : this.views) {
                if (!def.getName().equals(name)) continue;
                return def;
            }
        }
        return ret;
    }

    public List<ViewDefinition> getViewDefinitions() {
        return this.views;
    }

    public void doSelect(String name) {
        ViewDefinition def = this.currentViews.get(name);
        if (def == null) {
            return;
        }
        this.nav.navigateTo("/" + name);
        this.clearMenuSelection();
        def.b.addStyleName("selected");
    }

    public static class ViewDefinition {
        private String name;
        private String caption;
        private Class<? extends View> viewClass;
        private int badge;
        private Button b;
        private String iconName;
        private View view;
        private String helpStyle;
        private String help;

        public void setView(View view) {
            this.view = view;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        public void setHelpStyle(String style) {
            this.helpStyle = style;
        }

        public void showHelp(HelpManager helpManager) {
            String help = this.getHelp();
            if (help != null) {
                helpManager.showHelp(help, this.getCaption(), this.getHelpStyle());
            }
        }

        private String getHelpStyle() {
            return this.helpStyle;
        }

        private String getHelp() {
            return this.help;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public void setViewClass(Class<? extends View> clazz) {
            this.viewClass = clazz;
        }

        public void setBadge(int badge) {
            this.badge = badge;
        }

        public void setIconName(String name) {
            this.iconName = name;
        }

        public String getName() {
            return this.name;
        }

        public void updateCaption() {
            if (this.getBadge() != 0) {
                this.b.setCaption(this.getCaption() + "<span class=\"badge\">" + this.getBadge() + "</span>");
            } else {
                this.b.setCaption(this.getCaption());
            }
        }

        private void setNavButton(Button b) {
            this.b = b;
        }

        public int getBadge() {
            return this.badge;
        }

        public String getIconName() {
            return this.iconName;
        }

        public String getCaption() {
            return this.caption;
        }

        public Class<? extends View> getViewClass() {
            return this.viewClass;
        }

        public View getView() {
            return this.view;
        }
    }

    public static interface Connector {
        public String getUserName();

        public String getDefaultViewName();

        public List<String> getSettingsMenuCaptions();

        public void doSettingsMenuAction(MenuBar.MenuItem var1);

        public void doLogout();
    }
}

