/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Property;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import de.mhus.lib.vaadin.FilterRequest;

public class SearchField
extends HorizontalLayout {
    private ComboBox filter = new ComboBox();
    private Listener listener;
    private Button bSearch;

    public SearchField() {
        this.filter.setNewItemsAllowed(true);
        this.filter.setNewItemHandler(new AbstractSelect.NewItemHandler(){

            public void addNewItem(String newItemCaption) {
                SearchField.this.addKnownFacetName(newItemCaption);
                SearchField.this.filter.setValue((Object)newItemCaption);
            }
        });
        this.filter.setInputPrompt("Filter");
        this.filter.setImmediate(true);
        this.filter.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                SearchField.this.doFilter();
            }
        });
        this.addComponent((Component)this.filter);
        this.setExpandRatio((Component)this.filter, 1.0f);
        this.filter.setWidth("100%");
        this.bSearch = new Button();
        this.bSearch.setStyleName("icon-search");
        this.bSearch.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                SearchField.this.doFilter();
            }
        });
        this.addComponent((Component)this.bSearch);
        this.setExpandRatio((Component)this.bSearch, 0.0f);
        this.setWidth("100%");
    }

    protected void doFilter() {
        if (this.listener != null) {
            this.listener.doFilter(this);
        }
    }

    public void setInputPrompt(String prompt) {
        this.filter.setInputPrompt(prompt);
    }

    public void setValue(String value) {
        this.filter.setValue((Object)value);
    }

    public FilterRequest createFilterRequest() {
        return new FilterRequest((String)this.filter.getValue());
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void addKnownFacetName(String name) {
        if (!this.filter.containsId((Object)name)) {
            this.filter.addItem((Object)name);
        }
    }

    public static interface Listener {
        public void doFilter(SearchField var1);
    }
}

