/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.event.ShortcutListener;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public abstract class ModalDialog
extends Window {
    private static final long serialVersionUID = 1L;
    public static final Action CLOSE = new CloseAction("close", "Close");
    public static final Action OK = new Action("ok", "OK");
    protected Action[] actions = new Action[]{OK, CLOSE};
    protected HorizontalLayout buttonBar;
    protected boolean pack;
    protected String dialogWidth = "650px";

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public void setDialogWidth(String w) {
        this.dialogWidth = w;
    }

    public void show(UI ui) throws Exception {
        ui.addWindow((Window)this);
    }

    protected void initUI() throws Exception {
        this.setModal(true);
        VerticalLayout layout = new VerticalLayout();
        VerticalLayout layout2 = new VerticalLayout();
        this.setContent((Component)layout);
        layout.setMargin(true);
        layout.setSpacing(true);
        if (this.pack) {
            layout.setWidth("100%");
        } else {
            layout.setSizeFull();
        }
        this.setWidth(this.dialogWidth);
        if (!this.pack) {
            this.setHeight("90%");
        }
        this.initContent(layout2);
        this.buttonBar = new HorizontalLayout();
        this.buttonBar.setSpacing(true);
        this.updateButtons();
        layout.addComponent((Component)layout2);
        layout.setExpandRatio((Component)layout2, 1.0f);
        layout.addComponent((Component)this.buttonBar);
        layout.setComponentAlignment((Component)this.buttonBar, Alignment.MIDDLE_RIGHT);
        layout.setExpandRatio((Component)this.buttonBar, 0.0f);
        ShortcutListener enter = new ShortcutListener("Enter", 13, null){

            public void handleAction(Object sender, Object target) {
                for (Component c : ModalDialog.this.buttonBar) {
                    if (!(c instanceof Button) || ((Button)c).getData() == null || !((Action)((Button)c).getData()).isDefaultAction()) continue;
                    ((Button)c).click();
                    return;
                }
            }
        };
        layout.addShortcutListener(enter);
    }

    protected abstract void initContent(VerticalLayout var1) throws Exception;

    protected void updateButtons() {
        this.buttonBar.removeAllComponents();
        for (final Action a : this.actions) {
            Button b = new Button();
            b.setData((Object)a);
            b.setCaption(a.title);
            b.addListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    a.doAction(ModalDialog.this);
                }
            });
            this.buttonBar.addComponent((Component)b);
        }
    }

    protected abstract boolean doAction(Action var1);

    public static class CloseAction
    extends Action {
        public CloseAction(String id, String title) {
            super(id, title);
        }

        @Override
        public void doAction(ModalDialog dialog) {
            dialog.close();
        }
    }

    public static class Action {
        private String id;
        private String title;
        private boolean defaultAction;

        public Action(String id, String title) {
            this.id = id;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean equals(Object in) {
            if (in == null) {
                return false;
            }
            if (in instanceof Action) {
                return ((Action)in).id.equals(this.id);
            }
            return super.equals(in);
        }

        public String toString() {
            return this.id;
        }

        public void doAction(ModalDialog dialog) {
            if (dialog.doAction(this)) {
                dialog.close();
            }
        }

        public boolean isDefaultAction() {
            return this.defaultAction;
        }

        public void setDefaultAction(boolean defaultAction) {
            this.defaultAction = defaultAction;
        }
    }
}

