/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.vaadin.AbstractBeanListEditor;
import de.mhus.lib.vaadin.ManagedListEntity;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class LinkedListEditor<E>
extends AbstractBeanListEditor<E> {
    private static final long serialVersionUID = 1L;
    protected LinkedList<E> list = new LinkedList();
    protected LinkedList<E> deleted = new LinkedList();
    private PojoAttribute<Object> idAttribute;

    public LinkedListEditor(Class<E> beanClass, String schema, String idAttribute) {
        super(beanClass, schema);
        this.idAttribute = this.beanModel.getAttribute(idAttribute);
    }

    @Override
    protected E getEditableTarget(Object id) {
        E original = this.getTarget(id);
        E clone = this.createTarget();
        for (PojoAttribute attr : this.beanModel) {
            try {
                Object value = attr.get(original);
                attr.set(clone, value);
            }
            catch (Throwable t) {}
        }
        return clone;
    }

    @Override
    protected E createTarget() {
        try {
            Object out = this.beanClass.newInstance();
            if (out instanceof ManagedListEntity) {
                ((ManagedListEntity)out).doPostCreate(this);
            }
            return (E)out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void doCancel(E entry) {
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doCancel(this);
        }
    }

    @Override
    protected void doDelete(E entry) {
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPreDelete(this);
        }
        this.deleted.add(entry);
        this.list.remove(entry);
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPostDelete(this);
        }
    }

    @Override
    protected void doSave(E entry) {
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPreSave(this);
        }
        Object id = this.getId(entry);
        E original = this.getTarget(id);
        for (PojoAttribute attr : this.beanModel) {
            try {
                Object value = attr.get(entry);
                attr.set(original, value);
            }
            catch (Throwable t) {}
        }
        if (original instanceof ManagedListEntity) {
            ((ManagedListEntity)original).doPostSave(this);
        }
    }

    @Override
    protected E getTarget(Object id) {
        for (Object item : this.list) {
            if (!this.getId(item).equals(id)) continue;
            return item;
        }
        return null;
    }

    @Override
    protected Object getId(E entry) {
        try {
            Object id;
            if (entry instanceof ManagedListEntity && (id = ((ManagedListEntity)entry).doGetId(this)) != null) {
                return id;
            }
            return this.idAttribute.get(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected List<E> createFullDataList() {
        return this.list;
    }

    @Override
    protected void doSaveNew(E entry) {
        Object id = this.createId();
        try {
            boolean done = false;
            if (entry instanceof ManagedListEntity) {
                done = ((ManagedListEntity)entry).doPreNew(this, id);
            }
            if (!done) {
                this.idAttribute.set(entry, id);
            }
            this.list.add(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Object createId() {
        return UUID.randomUUID().toString();
    }
}

