/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.vaadin.SectionsSelector;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractSectionsPanel
extends HorizontalLayout
implements Observer {
    private static final long serialVersionUID = 1L;
    protected SectionsSelector selector = new SectionsSelector();
    protected Panel content;

    public AbstractSectionsPanel() {
        this.addComponent((Component)this.selector);
        this.content = new Panel();
        this.addComponent((Component)this.content);
        this.content.setSizeFull();
        this.setExpandRatio((Component)this.content, 1.0f);
        this.selector.eventHandler().register((Object)this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            return;
        }
        if (arg instanceof SectionsSelector.Event) {
            switch (((SectionsSelector.Event)arg).getEvent()) {
                case SECTION_CHANGED: {
                    SectionsSelector.Section sel = this.selector.getSelected();
                    if (sel == null) break;
                    this.doShow(sel);
                    break;
                }
                case SECTION_CHANGEING: {
                    SectionsSelector.Section sel = this.selector.getSelected();
                    if (sel == null) break;
                    this.doRemove(sel);
                    break;
                }
            }
        }
    }

    protected abstract void doShow(SectionsSelector.Section var1);

    protected abstract void doRemove(SectionsSelector.Section var1);

    protected void setContent(AbstractComponent c) {
        AbstractComponentContainer x = (AbstractComponentContainer)this.content.getContent();
        if (x == null) {
            x = new VerticalLayout();
            this.content.setContent((Component)x);
        }
        x.removeAllComponents();
        x.addComponent((Component)c);
    }
}

