/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.GridLayout;
import de.mhus.lib.core.activator.MutableActivator;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.LayoutBuilderWithStack;
import de.mhus.lib.form.LayoutComposite;
import de.mhus.lib.form.LayoutDataElement;
import de.mhus.lib.form.LayoutElement;
import de.mhus.lib.form.LayoutRoot;
import de.mhus.lib.form.UiElement;
import de.mhus.lib.vaadin.form2.UiAccordion;
import de.mhus.lib.vaadin.form2.UiCheckbox;
import de.mhus.lib.vaadin.form2.UiCombobox;
import de.mhus.lib.vaadin.form2.UiDate;
import de.mhus.lib.vaadin.form2.UiGroup;
import de.mhus.lib.vaadin.form2.UiInformation;
import de.mhus.lib.vaadin.form2.UiNumber;
import de.mhus.lib.vaadin.form2.UiPassword;
import de.mhus.lib.vaadin.form2.UiRichText;
import de.mhus.lib.vaadin.form2.UiTabsheet;
import de.mhus.lib.vaadin.form2.UiText;
import de.mhus.lib.vaadin.form2.UiTextArea;
import de.mhus.lib.vaadin.form2.UiVaadin;
import de.mhus.lib.vaadin.form2.UiVaadinActions;
import de.mhus.lib.vaadin.form2.UiVaadinComposite;
import de.mhus.lib.vaadin.form2.UiVaadinSplit;

public class VaadinFormBuilder
extends LayoutBuilderWithStack<UiVaadinComposite> {
    private GridLayout rootComposit;
    private ComponentContainer informationPane;

    public void createCompositStart(LayoutComposite composite) {
        this.log().d(new Object[]{"createCompositStart", composite});
        UiVaadinComposite ui = (UiVaadinComposite)composite.getUi();
        if (ui == null) {
            ui = new UiVaadinComposite();
            composite.setUi((UiElement)ui);
        }
        ui.createUi(this);
        if (ui.isTransparent()) {
            return;
        }
        this.push((Object)ui);
    }

    public void addComposite(LayoutComposite composite, Component layout) {
        if (this.currentComponent == null) {
            return;
        }
        int row = 0;
        row = composite.getOffset() > 0 && ((UiVaadinComposite)((Object)this.currentComponent)).getGrid() != null ? ((UiVaadinComposite)((Object)this.currentComponent)).getGrid().getRows() - 1 : ((UiVaadinComposite)((Object)this.currentComponent)).createRow();
        this.log().d(new Object[]{"add comp", composite.getOffset(), row, composite.getOffset() + composite.getColumns() - 1, row});
        ((UiVaadinComposite)((Object)this.currentComponent)).addComponent((LayoutElement)composite, layout, composite.getOffset(), row, composite.getOffset() + composite.getColumns() - 1, row);
    }

    public void createCompositStop(LayoutComposite composite) {
        try {
            this.log().d(new Object[]{"createCompositStop", composite.getConfig().getName()});
        }
        catch (MException e) {
            this.log().w(new Object[]{e});
        }
        UiElement ui = composite.getUi();
        if (ui != null && ((UiVaadinComposite)ui).isTransparent()) {
            return;
        }
        this.pop();
    }

    public void createRootStart(LayoutRoot root) {
        UiVaadinComposite ui = new UiVaadinComposite();
        root.setUi((UiElement)ui);
        ui.createUi(this);
        this.rootComposit = ui.getGrid();
        this.push((Object)ui);
    }

    public void createRootStop(LayoutRoot root) {
        this.pop();
    }

    public void createSimpleElement(LayoutElement element) {
    }

    public void createDataElement(LayoutDataElement element) throws MException {
        this.log().d(new Object[]{"createDataElement", element});
        UiVaadin ui = (UiVaadin)element.getUi();
        ui.createUi(this);
    }

    public void initActivator(MutableActivator act) {
        act.addMap(UiElement.class, "text", UiText.class);
        act.addMap(UiElement.class, "password", UiPassword.class);
        act.addMap(UiElement.class, "richtext", UiRichText.class);
        act.addMap(UiElement.class, "textarea", UiTextArea.class);
        act.addMap(UiElement.class, "checkbox", UiCheckbox.class);
        act.addMap(UiElement.class, "combobox", UiCombobox.class);
        act.addMap(UiElement.class, "date", UiDate.class);
        act.addMap(UiElement.class, "number", UiNumber.class);
        act.addMap(UiElement.class, "information", UiInformation.class);
        act.addMap(LayoutElement.class, "composite", UiVaadinComposite.class);
        act.addMap(LayoutElement.class, "split", UiVaadinSplit.class);
        act.addMap(LayoutElement.class, "actions", UiVaadinActions.class);
        act.addMap(UiElement.class, "group", UiGroup.class);
        act.addMap(UiElement.class, "tabsheet", UiTabsheet.class);
        act.addMap(UiElement.class, "accordion", UiAccordion.class);
        act.addMap(UiElement.class, "root", UiVaadinComposite.class);
    }

    public GridLayout getRootComposit() {
        return this.rootComposit;
    }

    public UiVaadinComposite getCurrentComposite() {
        return (UiVaadinComposite)((Object)this.currentComponent);
    }

    public ComponentContainer getInformationPane() {
        return this.informationPane;
    }

    public void setInformationPane(ComponentContainer informationPane) {
        this.informationPane = informationPane;
    }
}

