/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.data.Property;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.DataConnector;
import de.mhus.lib.vaadin.form2.UiVaadin;

public class UiText
extends UiVaadin {
    protected AbstractField field;

    protected void doConnect() {
    }

    protected void doDisconnect() {
    }

    protected Object getValueFromDataSource(DataConnector data) throws MException {
        return data.getString("");
    }

    protected void setValueToDataSource(DataConnector data) throws MException {
        data.setString((String)this.field.getValue());
    }

    protected void setValueToField(Object arg) {
        this.field.setValue(arg);
    }

    protected Object getValueFromField() {
        return this.field.getValue();
    }

    protected void doUpdateData(DataConnector data) throws MException {
        Object arg = this.getValueFromDataSource(data);
        if (this.equals(arg, this.getValueFromField())) {
            return;
        }
        this.setValueToField(arg);
    }

    protected void doUpdateEnabled(DataConnector data) throws MException {
        boolean arg = data.getBoolean(this.field.isEnabled());
        if (this.equals(arg, this.field.isEnabled())) {
            return;
        }
        this.field.setEnabled(data.getBoolean(true));
    }

    protected void doUpdateDescription(DataConnector data) throws MException {
        if (this.field instanceof AbstractTextField) {
            String arg = data.getString(((AbstractTextField)this.field).getInputPrompt());
            if (this.equals(arg, ((AbstractTextField)this.field).getInputPrompt())) {
                return;
            }
            ((AbstractTextField)this.field).setInputPrompt(arg);
        }
    }

    @Override
    public void doUpdate(DataConnector data) throws MException {
        if (this.field == null) {
            return;
        }
        if (data.getTaskName().equals("data")) {
            this.doUpdateData(data);
            return;
        }
        if (data.getTaskName().equals("enabled")) {
            this.doUpdateEnabled(data);
            return;
        }
        if (data.getTaskName().equals("description")) {
            this.doUpdateDescription(data);
            return;
        }
        super.doUpdate(data);
    }

    @Override
    protected Component getField() throws MException {
        if (this.field == null) {
            this.field = this.createTextField();
            this.field.setWidth("100%");
            if (this.field instanceof AbstractTextField) {
                ((AbstractTextField)this.field).setInputPrompt(this.getElement().getDescription());
            }
            this.getElement().fireAllDataSources();
            this.field.addListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1L;

                public void valueChange(Property.ValueChangeEvent event) {
                    try {
                        UiText.this.setValueToDataSource(UiText.this.getElement().getDataConnector("data"));
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.prepareInputField(this.field);
        }
        return this.field;
    }

    protected AbstractField createTextField() throws MException {
        return new TextField();
    }
}

