/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.ui.AbstractField;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.DataConnector;
import de.mhus.lib.vaadin.aqua.SpinnerNumberField;
import de.mhus.lib.vaadin.form2.UiText;

public class UiNumber
extends UiText {
    private String type;

    @Override
    protected AbstractField createTextField() throws MException {
        SpinnerNumberField spinner = null;
        this.type = this.getElement().getConfig().getString("number", "integer").toLowerCase();
        spinner = this.type.equals("double") ? new SpinnerNumberField(Double.class) : (this.type.equals("float") ? new SpinnerNumberField(Float.class) : (this.type.equals("long") ? new SpinnerNumberField(Long.class) : new SpinnerNumberField(Integer.class)));
        spinner.setAllowNegative(this.getElement().getConfig().getBoolean("allow_negative", true));
        spinner.setAllowNull(this.getElement().getConfig().getBoolean("allow_null", false));
        spinner.setMaxVal(this.getElement().getConfig().getLong("max", Long.MAX_VALUE));
        spinner.setMinVal(this.getElement().getConfig().getLong("min", Long.MIN_VALUE));
        return spinner;
    }

    @Override
    protected void setValueToField(Object arg) {
        ((SpinnerNumberField)this.field).setValue(String.valueOf(arg));
    }

    @Override
    protected void setValueToDataSource(DataConnector data) throws MException {
        data.setNumber(((SpinnerNumberField)this.field).getNumberValue());
    }

    @Override
    protected Object getValueFromDataSource(DataConnector data) throws MException {
        Object d = this.field.getValue();
        if (d == null) {
            return 0;
        }
        try {
            return data.getNumber((Number)Double.parseDouble(String.valueOf(d)));
        }
        catch (Throwable t) {
            return data.getNumber((Number)0);
        }
    }
}

