/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.ComboBox;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.DataConnector;
import de.mhus.lib.vaadin.form2.UiText;
import java.util.Map;

public class UiCombobox
extends UiText {
    private IndexedContainer container;
    private Object value;

    @Override
    protected void setValueToField(Object arg) {
        this.value = arg;
        ComboBox editor = (ComboBox)this.field;
        if (!editor.containsId(arg)) {
            editor.unselect(editor.getValue());
        } else {
            editor.select(arg);
        }
    }

    @Override
    public void doUpdate(DataConnector data) throws MException {
        if (data.getTaskName().equals("options")) {
            String[] arg = data.getObject();
            this.container.removeAllItems();
            if (arg == null) {
                return;
            }
            if (this.field.getValue() != null) {
                this.value = this.field.getValue();
            }
            if (arg instanceof String) {
                arg = ((String)arg).split(",");
            }
            if (arg instanceof String[]) {
                String[][] next = new String[arg.length][];
                for (int i = 0; i < arg.length; ++i) {
                    next[i] = arg[i].split("=");
                }
                arg = next;
            }
            if (arg instanceof String[][]) {
                for (String[] pair : (String[][])arg) {
                    if (pair.length != 2) continue;
                    Item item = this.container.addItem((Object)pair[0]);
                    item.getItemProperty((Object)"title").setValue((Object)pair[1]);
                }
            }
            if (arg instanceof Map) {
                for (Map.Entry pair : ((Map)arg).entrySet()) {
                    Item item = this.container.addItem((Object)String.valueOf(pair.getKey()));
                    item.getItemProperty((Object)"title").setValue((Object)String.valueOf(pair.getValue()));
                }
            }
            this.setValueToField(this.value);
            return;
        }
        super.doUpdate(data);
    }

    @Override
    protected AbstractField createTextField() {
        ComboBox out = new ComboBox();
        out.setItemCaptionPropertyId((Object)"title");
        out.setItemCaptionMode(AbstractSelect.ITEM_CAPTION_MODE_PROPERTY);
        out.setFilteringMode(AbstractSelect.Filtering.FILTERINGMODE_CONTAINS);
        out.setNullSelectionAllowed(false);
        this.container = new IndexedContainer();
        this.container.addContainerProperty((Object)"title", String.class, (Object)"");
        out.setContainerDataSource((Container)this.container);
        return out;
    }
}

