/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.event.ItemClickEvent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.form.control.AbstractWizzard;
import de.mhus.lib.form.control.WizzardCall;
import de.mhus.lib.vaadin.ColumnDefinition;
import de.mhus.lib.vaadin.FilterRequest;
import de.mhus.lib.vaadin.ModalDialog;
import de.mhus.lib.vaadin.SearchField;
import de.mhus.lib.vaadin.SimpleTable;
import de.mhus.lib.vaadin.form2.UiVaadin;

public abstract class AbstractListWizzard
extends AbstractWizzard {
    private boolean showSearchField = true;

    protected void doExecute(WizzardCall call) {
        UI window = ((UiVaadin)call.getElement().getUi()).getWindow();
        try {
            ListDialog dialog = new ListDialog(call);
            dialog.show(window);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowSearchField() {
        return this.showSearchField;
    }

    public void setShowSearchField(boolean showSearchField) {
        this.showSearchField = showSearchField;
    }

    public abstract boolean setSelected(WizzardCall var1, Object var2);

    public abstract ColumnDefinition[] createColumnDefinitions();

    public abstract void fillTable(WizzardCall var1, SimpleTable var2, FilterRequest var3);

    private class ListDialog
    extends ModalDialog {
        private static final long serialVersionUID = 1L;
        private WizzardCall call;
        private ResourceNode options;
        private ModalDialog.Action confirm;
        private ModalDialog.Action cancel;
        private SimpleTable table;
        private SearchField filter;

        private ListDialog(WizzardCall call) throws Exception {
            this.call = call;
            this.options = call.getOptions();
            if (this.options == null) {
                this.options = new HashConfig();
            }
            this.confirm = new ModalDialog.Action("confirm", this.options.getExtracted("confirm", "OK"));
            this.cancel = new ModalDialog.Action("cancel", this.options.getExtracted("cancel", "Cancel"));
            this.actions = new ModalDialog.Action[]{this.confirm, this.cancel};
            this.initUI();
            this.setCaption(this.options.getExtracted("title", call.getElement().getTitle()));
        }

        @Override
        protected void initContent(VerticalLayout layout) throws Exception {
            if (this.options.isProperty("description")) {
                Label label = new Label(this.options.getExtracted("description", this.call.getElement().getTitle()));
                label.setContentMode(Label.CONTENT_XHTML);
                layout.addComponent((Component)label);
            }
            this.filter = new SearchField();
            this.filter.setInputPrompt("Filter");
            this.filter.setWidth("100%");
            this.filter.setListener(new SearchField.Listener(){

                @Override
                public void doFilter(SearchField searchField) {
                    ListDialog.this.doFilter();
                }
            });
            if (AbstractListWizzard.this.showSearchField) {
                layout.addComponent((Component)this.filter);
            }
            this.table = new SimpleTable();
            this.table.setSelectable(true);
            this.table.setMultiSelect(false);
            layout.addComponent((Component)this.table);
            layout.setExpandRatio((Component)this.table, 1.0f);
            this.table.addListener(new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = 1L;

                public void itemClick(ItemClickEvent event) {
                    if (event.isDoubleClick()) {
                        ListDialog.this.confirm.doAction(ListDialog.this);
                    }
                }
            });
            this.table.createDataSource(AbstractListWizzard.this.createColumnDefinitions());
            AbstractListWizzard.this.fillTable(this.call, this.table, new FilterRequest(""));
        }

        protected void doFilter() {
            this.table.removeAllItems();
            AbstractListWizzard.this.fillTable(this.call, this.table, this.filter.createFilterRequest());
        }

        @Override
        protected boolean doAction(ModalDialog.Action action) {
            if (action.equals(this.cancel)) {
                return true;
            }
            Object selected = this.table.getValue();
            return AbstractListWizzard.this.setSelected(this.call, selected);
        }
    }
}

