/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.container;

import com.vaadin.data.Property;
import com.vaadin.data.util.AbstractProperty;
import com.vaadin.data.util.NestedMethodProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.data.util.VaadinPropertyDescriptor;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoParser;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MhuBeanItem<BT>
extends PropertysetItem {
    private final BT bean;

    public MhuBeanItem(BT bean) {
        this(bean, MhuBeanItem.getPropertyDescriptors(bean.getClass()));
    }

    MhuBeanItem(BT bean, Map<String, PojoPropertyDescriptor<BT>> propertyDescriptors) {
        this.bean = bean;
        for (VaadinPropertyDescriptor vaadinPropertyDescriptor : propertyDescriptors.values()) {
            this.addItemProperty(vaadinPropertyDescriptor.getName(), vaadinPropertyDescriptor.createProperty(bean));
        }
    }

    public MhuBeanItem(BT bean, Collection<?> propertyIds) {
        this.bean = bean;
        LinkedHashMap<String, PojoPropertyDescriptor<?>> pds = MhuBeanItem.getPropertyDescriptors(bean.getClass());
        for (Object id : propertyIds) {
            VaadinPropertyDescriptor pd = pds.get(id);
            if (pd == null) continue;
            this.addItemProperty(pd.getName(), pd.createProperty(bean));
        }
    }

    public MhuBeanItem(BT bean, String ... propertyIds) {
        this(bean, Arrays.asList(propertyIds));
    }

    static <BT> LinkedHashMap<String, PojoPropertyDescriptor<BT>> getPropertyDescriptors(Class<BT> beanClass) {
        LinkedHashMap<String, PojoPropertyDescriptor<BT>> pdMap = new LinkedHashMap<String, PojoPropertyDescriptor<BT>>();
        PojoModel m = new PojoParser().parse(beanClass).getModel();
        for (String name : m.getAttributeNames()) {
            PojoAttribute attr = m.getAttribute(name);
            pdMap.put(name, new PojoPropertyDescriptor(attr));
        }
        return pdMap;
    }

    private static List<PropertyDescriptor> getBeanPropertyDescriptor(Class<?> beanClass) throws IntrospectionException {
        if (beanClass.isInterface()) {
            ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
            for (Class<?> cls : beanClass.getInterfaces()) {
                propertyDescriptors.addAll(MhuBeanItem.getBeanPropertyDescriptor(cls));
            }
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            propertyDescriptors.addAll(Arrays.asList(info.getPropertyDescriptors()));
            return propertyDescriptors;
        }
        BeanInfo info = Introspector.getBeanInfo(beanClass);
        return Arrays.asList(info.getPropertyDescriptors());
    }

    public void expandProperty(String propertyId, String ... subPropertyIds) {
        HashSet<String> subPropertySet = new HashSet<String>(Arrays.asList(subPropertyIds));
        if (0 == subPropertyIds.length) {
            Class propertyType = this.getItemProperty(propertyId).getType();
            LinkedHashMap<String, PojoPropertyDescriptor<BT>> pds = MhuBeanItem.getPropertyDescriptors(propertyType);
            subPropertySet.addAll(pds.keySet());
        }
        for (String subproperty : subPropertySet) {
            String qualifiedPropertyId = propertyId + "." + subproperty;
            this.addNestedProperty(qualifiedPropertyId);
        }
        this.removeItemProperty(propertyId);
    }

    public void addNestedProperty(String nestedPropertyId) {
        this.addItemProperty(nestedPropertyId, (Property)new NestedMethodProperty(this.getBean(), nestedPropertyId));
    }

    public BT getBean() {
        return this.bean;
    }

    public static class PojoProperty<T>
    extends AbstractProperty<T> {
        private Object bean;
        private PojoAttribute attr;

        public PojoProperty(PojoAttribute attr, Object bean) {
            this.attr = attr;
            this.bean = bean;
        }

        public T getValue() {
            try {
                return (T)this.attr.get(this.bean);
            }
            catch (IOException e) {
                return null;
            }
        }

        public void setValue(T newValue) throws Property.ReadOnlyException {
            try {
                this.attr.set(this.bean, newValue);
            }
            catch (IOException e) {
                throw new Property.ReadOnlyException("Can't write " + this.attr.getName() + ": " + e);
            }
        }

        public Class<? extends T> getType() {
            return this.attr.getType();
        }
    }

    public static class PojoPropertyDescriptor<BT>
    implements VaadinPropertyDescriptor<BT> {
        private PojoAttribute<?> attr;

        public PojoPropertyDescriptor(PojoAttribute<?> attr) {
            this.attr = attr;
        }

        public String getName() {
            return this.attr.getName();
        }

        public Class<?> getPropertyType() {
            return this.attr.getType();
        }

        public Property<?> createProperty(BT bean) {
            return new PojoProperty(this.attr, bean);
        }

        public PojoAttribute<?> getPojoAttribute() {
            return this.attr;
        }
    }
}

