/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Container;
import com.vaadin.data.util.converter.StringToBooleanConverter;
import com.vaadin.data.util.converter.StringToDoubleConverter;
import com.vaadin.data.util.converter.StringToFloatConverter;
import com.vaadin.data.util.converter.StringToIntegerConverter;
import com.vaadin.data.util.converter.StringToLongConverter;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.vaadin.ColumnModel;
import de.mhus.lib.vaadin.converter.BooleanPrimitiveConverter;
import de.mhus.lib.vaadin.converter.DateConverter;
import de.mhus.lib.vaadin.converter.DoublePrimitiveConverter;
import de.mhus.lib.vaadin.converter.FloatPrimitiveConverter;
import de.mhus.lib.vaadin.converter.IntPrimitiveConverter;
import de.mhus.lib.vaadin.converter.LongPrimitiveConverter;
import de.mhus.lib.vaadin.converter.SqlDateConverter;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class MhuTable
extends Table {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(MhuTable.class);
    protected Object editableId;
    private boolean tableEditable = false;
    private HashMap<String, ColumnModel> columnModels = new HashMap();

    public MhuTable() {
        this.setTableFieldFactory(new TableFieldFactory(){

            public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
                Field<?> f = MhuTable.this.createField(container, itemId, propertyId, uiContext);
                return f;
            }
        });
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                if (MhuTable.this.tableEditable && event.getButton() == MouseEventDetails.MouseButton.LEFT && event.isDoubleClick()) {
                    MhuTable.this.doActionEditable(event.getItemId());
                } else if (event.getButton() == MouseEventDetails.MouseButton.LEFT) {
                    MhuTable.this.doActionEditable(null);
                }
            }
        });
    }

    protected Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
        ColumnModel model = this.getColumnModel(String.valueOf(propertyId));
        boolean editable = this.tableEditable && itemId.equals(this.editableId) && model.isEditable();
        Field<?> f = null;
        Class type = container.getType(propertyId);
        f = this.createFieldForType(type);
        f.setCaption(null);
        f.setWidth("100%");
        f.setReadOnly(!editable);
        if (f instanceof AbstractField) {
            if (model.getConverter() == null) {
                model.setConverter(MhuTable.findDefaultConverter(model, type));
            }
            if (model.getConverter() != null) {
                ((AbstractField)f).setConverter(model.generateConverter(type));
            }
        }
        return f;
    }

    protected boolean doActionSave() {
        return false;
    }

    public void doActionEditable(Object itemId) {
        this.editableId = itemId;
        if (itemId == null) {
            this.setEditable(false);
            this.removeStyleName("editable");
        } else {
            this.addStyleName("editable");
            this.setEditable(true);
        }
    }

    public Object getEditedObject() {
        return this.editableId;
    }

    public static Class<?> findDefaultConverter(ColumnModel model, Class<?> type) {
        log.t(new Object[]{"Default Converter", model.getPropertyId(), type});
        if (type == Integer.TYPE) {
            return IntPrimitiveConverter.class;
        }
        if (type == Boolean.TYPE) {
            return BooleanPrimitiveConverter.class;
        }
        if (type == Long.TYPE) {
            return LongPrimitiveConverter.class;
        }
        if (type == Double.TYPE) {
            return DoublePrimitiveConverter.class;
        }
        if (type == Float.TYPE) {
            return FloatPrimitiveConverter.class;
        }
        if (type == Integer.class) {
            return StringToIntegerConverter.class;
        }
        if (type == java.util.Date.class) {
            return DateConverter.class;
        }
        if (type == Date.class) {
            return SqlDateConverter.class;
        }
        if (type == Boolean.class) {
            return StringToBooleanConverter.class;
        }
        if (type == Long.class) {
            return StringToLongConverter.class;
        }
        if (type == Double.class) {
            return StringToDoubleConverter.class;
        }
        if (type == Float.class) {
            return StringToFloatConverter.class;
        }
        return null;
    }

    protected Field<?> createFieldForType(Class<?> type) {
        return new TextField();
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean tableEditable) {
        this.tableEditable = tableEditable;
    }

    public Collection<?> getSelectedValues() {
        Object o = this.getValue();
        if (o == null) {
            return new LinkedList();
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        LinkedList<Object> out = new LinkedList<Object>();
        if (o instanceof Object[]) {
            MCollection.copyArray((Object[])((Object[])o), out);
        } else {
            out.add(o);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnModel getColumnModel(String colId) {
        HashMap<String, ColumnModel> hashMap = this.columnModels;
        synchronized (hashMap) {
            ColumnModel ret = this.columnModels.get(colId);
            if (ret == null) {
                ret = new ColumnModel(this, colId);
                this.columnModels.put(colId, ret);
            }
            return ret;
        }
    }
}

