/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.server.VaadinServlet;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.MConfigFactory;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;

public class MVaadinServlet
extends VaadinServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(MVaadinServlet.class);
    private ResourceNode config;

    public void init() throws ServletException {
        super.init();
        String mhusConfigPath = this.getServletConfig().getInitParameter("mhus.config");
        URL mhusConfigUrl = null;
        if (mhusConfigPath != null) {
            try {
                mhusConfigUrl = new File(mhusConfigPath).toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.i(new Object[]{mhusConfigPath, e});
            }
        }
        if (mhusConfigUrl == null) {
            try {
                mhusConfigUrl = MSystem.locateResource((Object)((Object)this), (String)this.getApplicationConfigName());
            }
            catch (IOException e) {
                log.i(new Object[]{this.getApplicationConfigName(), e});
            }
        }
        if (mhusConfigUrl != null) {
            try {
                this.config = ((MConfigFactory)MSingleton.get().getBaseControl().base((Object)this).base(MConfigFactory.class)).createConfigFor(mhusConfigUrl.toURI());
            }
            catch (Exception e) {
                log.i(new Object[]{mhusConfigPath, e});
            }
        } else {
            this.config = new HashConfig();
        }
        this.doInit();
    }

    protected void doInit() {
    }

    protected String getApplicationConfigName() {
        return "config.xml";
    }

    public ResourceNode getConfig() {
        return this.config;
    }

    public void destroy() {
        super.destroy();
    }
}

