/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Property;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.vaadin.ColumnDefinition;
import de.mhus.lib.vaadin.ConfirmDialog;
import de.mhus.lib.vaadin.FilterRequest;
import de.mhus.lib.vaadin.SearchField;
import de.mhus.lib.vaadin.SimpleTable;
import de.mhus.lib.vaadin.form2.VaadinPojoForm;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractListEditor<E>
extends VerticalLayout
implements MNlsProvider {
    private static final long serialVersionUID = 1L;
    private static final Object MY_NEW_MARKER = new Object();
    protected SimpleTable table;
    private Button bNew;
    private Button bUpdate;
    private Button bDelete;
    protected Object editMode;
    private VaadinPojoForm model;
    protected SearchField filter;
    private boolean showSearchField = true;
    private Panel detailsPanel;
    private boolean showInformation = true;
    private VerticalLayout informationPane;
    private Panel modelPanel;
    private boolean fullSize;
    private VerticalLayout detailsPanelContent;
    private MNls nls;
    private boolean modified = false;

    public void initUI() {
        if (this.fullSize) {
            this.setSizeFull();
        }
        this.setSpacing(true);
        this.setMargin(true);
        this.filter = new SearchField();
        this.filter.setListener(new SearchField.Listener(){

            @Override
            public void doFilter(SearchField searchField) {
                AbstractListEditor.this.doFilter();
            }
        });
        this.table = new SimpleTable(this.getTableName());
        this.table.setSelectable(true);
        this.table.setMultiSelect(false);
        this.table.setImmediate(true);
        this.table.setSizeFull();
        this.table.createDataSource(this.createColumnDefinitions());
        this.fillDataSource(new FilterRequest(""));
        this.table.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                AbstractListEditor.this.doSelectionChanged();
            }
        });
        this.table.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                if (AbstractListEditor.this.editMode == null && event.isDoubleClick()) {
                    AbstractListEditor.this.doUpdate();
                }
            }
        });
        this.detailsPanel = new Panel(this.getDetailsName());
        this.detailsPanel.setWidth("100%");
        this.detailsPanelContent = new VerticalLayout();
        this.detailsPanel.setContent((Component)this.detailsPanelContent);
        if (this.fullSize) {
            this.detailsPanel.setSizeFull();
        }
        if (this.showInformation) {
            this.informationPane = new VerticalLayout();
            this.detailsPanelContent.addComponent((Component)this.informationPane);
            this.informationPane.setWidth("100%");
        }
        try {
            this.modelPanel = new Panel();
            this.modelPanel.setWidth("100%");
            if (this.fullSize) {
                this.modelPanel.setSizeFull();
            }
            this.modelPanel.setStyleName("light");
            this.detailsPanelContent.addComponent((Component)this.modelPanel);
            this.model = this.createForm();
            this.model.setInformationContainer((ComponentContainer)this.informationPane);
            this.model.doBuild((AbstractComponentContainer)this.detailsPanelContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HorizontalLayout buttonBar = new HorizontalLayout();
        this.bNew = new Button(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
        buttonBar.addComponent((Component)this.bNew);
        this.bNew.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doNew();
            }
        });
        this.bUpdate = new Button(MNls.find((MNlsProvider)this, (String)"button.edit=Edit"));
        buttonBar.addComponent((Component)this.bUpdate);
        this.bUpdate.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doUpdate();
            }
        });
        this.bDelete = new Button(MNls.find((MNlsProvider)this, (String)"button.delete=Delete"));
        buttonBar.addComponent((Component)this.bDelete);
        this.bDelete.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doDelete();
            }
        });
        this.editMode = null;
        this.createCustomButtons(buttonBar);
        this.composeElements((AbstractComponent)this.filter, (AbstractComponent)this.table, (AbstractComponent)this.detailsPanel, (AbstractComponent)buttonBar);
        this.updateEnabled();
    }

    protected void createCustomButtons(HorizontalLayout buttonBar) {
    }

    protected String getDetailsName() {
        return MNls.find((MNlsProvider)this, (String)"panel.details.caption=Details");
    }

    protected void doFilter() {
        this.updateDataSource();
    }

    protected void composeElements(AbstractComponent filter, AbstractComponent table, AbstractComponent formPanel, AbstractComponent buttonBar) {
        if (this.showSearchField) {
            this.addComponent((Component)filter);
        }
        VerticalSplitPanel split = new VerticalSplitPanel();
        split.setFirstComponent((Component)table);
        table.setSizeUndefined();
        table.setSizeFull();
        split.setSecondComponent((Component)formPanel);
        split.setSizeFull();
        this.addComponent((Component)split);
        this.setExpandRatio((Component)split, 1.0f);
        this.addComponent((Component)buttonBar);
        this.setSizeFull();
    }

    protected abstract ColumnDefinition[] createColumnDefinitions();

    protected String getTableName() {
        return MNls.find((MNlsProvider)this, (String)"panel.table.caption=Table");
    }

    protected abstract E createTarget();

    protected VaadinPojoForm createForm() {
        VaadinPojoForm form = new VaadinPojoForm();
        form.setPojo(this.createTarget());
        return form;
    }

    protected void doSelectionChanged() {
        if (this.editMode != null) {
            return;
        }
        Object selectedId = this.table.getValue();
        Object target = null;
        target = selectedId == null ? this.createTarget() : this.getTarget(selectedId);
        this.model.setPojo(target);
        this.updateEnabled();
    }

    protected void doDelete() {
        if (this.editMode != null) {
            this.doCancel();
            return;
        }
        Object selectedId = this.table.getValue();
        if (selectedId == null || !this.canDelete(selectedId)) {
            return;
        }
        final E selectedObj = this.getTarget(selectedId);
        if (selectedObj == null) {
            return;
        }
        ConfirmDialog.show(this.getUI(), MNls.find((MNlsProvider)this, (String)"confirm.delete=Delete"), MNls.find((MNlsProvider)this, (String)"confirm.question=Are you sure?"), MNls.find((MNlsProvider)this, (String)"confirm.yes=Yes"), MNls.find((MNlsProvider)this, (String)"confirm.no=Cancel"), new ConfirmDialog.Listener(){

            @Override
            public void onClose(ConfirmDialog dialog) {
                if (dialog.isConfirmed()) {
                    AbstractListEditor.this.doDelete(selectedObj);
                    AbstractListEditor.this.model.setPojo(AbstractListEditor.this.createTarget());
                    AbstractListEditor.this.updateDataSource();
                    AbstractListEditor.this.modified = true;
                }
            }
        });
    }

    protected void doCancel() {
        if (this.editMode == null) {
            return;
        }
        if (!MY_NEW_MARKER.equals(this.editMode)) {
            this.doCancel(this.getTarget(this.editMode));
        }
        this.editMode = null;
        this.model.setPojo(this.createTarget());
        this.updateEnabled();
    }

    protected abstract void doCancel(E var1);

    protected abstract void doDelete(E var1);

    protected void doUpdate() {
        if (this.editMode == null) {
            Object selectedId = this.table.getValue();
            if (selectedId == null || !this.canUpdate(selectedId)) {
                return;
            }
            try {
                this.doUpdate(selectedId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (!this.canUpdate(this.editMode)) {
                    return;
                }
                Object entity = this.model.getPojo();
                if (MY_NEW_MARKER.equals(this.editMode)) {
                    this.doSaveNew(entity);
                } else {
                    this.doSave(entity);
                }
                this.updateDataSource();
                this.modified = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.editMode = null;
        }
        this.updateEnabled();
    }

    protected void doSaveNew(E entity) {
        this.doSave(entity);
    }

    protected void doUpdate(Object selectedId) {
        this.editMode = selectedId;
        if (MY_NEW_MARKER.equals(this.editMode)) {
            return;
        }
        E target = this.getEditableTarget(this.editMode);
        this.model.setPojo(target);
    }

    protected abstract void doSave(E var1);

    protected E getEditableTarget(Object id) {
        return this.getTarget(id);
    }

    protected abstract E getTarget(Object var1);

    protected void doNew() {
        if (this.editMode != null || !this.canNew()) {
            return;
        }
        this.editMode = MY_NEW_MARKER;
        this.model.setPojo(this.createTarget());
        this.updateEnabled();
    }

    protected void updateEnabled() {
        Object selectedId = this.table.getValue();
        if (!this.isEditMode()) {
            this.bNew.setEnabled(this.canNew());
            this.bNew.setCaption(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
            this.bUpdate.setEnabled(selectedId != null && this.canUpdate(selectedId));
            this.bUpdate.setCaption(MNls.find((MNlsProvider)this, (String)"button.edit=Edit"));
            this.bDelete.setEnabled(selectedId != null && this.canDelete(selectedId));
            this.bDelete.setCaption(MNls.find((MNlsProvider)this, (String)"button.delete=Delete"));
            this.model.setEnabled(false);
            this.table.setEnabled(true);
        } else {
            this.bNew.setEnabled(false);
            this.bNew.setCaption(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
            this.bUpdate.setEnabled(true);
            this.bUpdate.setCaption(MNls.find((MNlsProvider)this, (String)"button.save=Set"));
            this.bDelete.setEnabled(true);
            this.bDelete.setCaption(MNls.find((MNlsProvider)this, (String)"button.cancel=Cancel"));
            this.model.setEnabled(true);
            this.table.setEnabled(false);
        }
        this.doUpdateEnabled(selectedId);
    }

    protected void doUpdateEnabled(Object selectedId) {
    }

    public boolean isEditMode() {
        return this.editMode != null;
    }

    public boolean canDelete(Object selectedId) {
        return true;
    }

    public boolean canUpdate(Object selectedId) {
        return true;
    }

    public boolean canNew() {
        return true;
    }

    protected void fillDataSource(FilterRequest filter) {
        try {
            this.table.removeAllItems();
            for (E entity : this.createDataList(filter)) {
                this.table.addRow(this.getId(entity), this.getValues(entity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Object[] getValues(E var1);

    protected abstract Object getId(E var1);

    protected abstract List<E> createDataList(FilterRequest var1);

    public void updateDataSource() {
        try {
            LinkedList<Object> newIds = new LinkedList<Object>();
            for (E entity : this.createDataList(this.filter.createFilterRequest())) {
                Object[] values;
                Object id = this.getId(entity);
                if (!this.table.updateRow(id, values = this.getValues(entity))) {
                    this.table.addRow(id, values);
                }
                newIds.add(id);
            }
            for (E id : new LinkedList(this.table.getItemIds())) {
                if (newIds.contains(id)) continue;
                this.table.removeItem(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowSearchField() {
        return this.showSearchField;
    }

    public void setShowSearchField(boolean showSearchField) {
        this.showSearchField = showSearchField;
    }

    public void doUpdateCaptions() {
        this.table.setCaption(this.getTableName());
        this.detailsPanel.setCaption(this.getDetailsName());
    }

    public E getSingleSelected() {
        if (this.isEditMode()) {
            return this.getTarget(this.editMode);
        }
        Object selectedId = this.table.getValue();
        if (selectedId == null) {
            return null;
        }
        return this.getTarget(selectedId);
    }

    public boolean isShowInformation() {
        return this.showInformation;
    }

    public void setShowInformation(boolean showInformation) {
        this.showInformation = showInformation;
    }

    public boolean isFullSize() {
        return this.fullSize;
    }

    public void setFullSize(boolean fullSize) {
        this.fullSize = fullSize;
    }

    public MNls getNls() {
        return this.nls;
    }

    public void setNls(MNls nls) {
        this.nls = nls;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

