/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.mutable;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.activator.DefaultActivator;
import de.mhus.lib.core.lang.Base;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.logging.MLogFactory;
import de.mhus.lib.core.system.ApiInitialize;
import de.mhus.lib.core.system.CfgManager;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.core.system.IApiInternal;
import de.mhus.lib.core.system.SingleMLogInstanceFactory;
import de.mhus.lib.logging.JavaLoggerFactory;
import de.mhus.lib.mutable.KarafBaseControl;
import de.mhus.lib.mutable.KarafHousekeeper;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class KarafMApiImpl
implements IApi,
ApiInitialize,
IApiInternal {
    private LogFactory logFactory;
    private BaseControl baseControl;
    private CfgManager configProvider;
    private boolean fullTrace = false;
    private HashSet<String> logTrace = new HashSet();
    private KarafHousekeeper housekeeper;
    private File baseDir = new File("data/mhus");
    private MLogFactory mlogFactory;

    public KarafMApiImpl() {
        this.baseDir.mkdirs();
    }

    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    public MActivator createActivator() {
        return new DefaultActivator();
    }

    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    public synchronized CfgManager getCfgManager() {
        if (this.configProvider == null) {
            this.configProvider = new CfgManager((IApiInternal)this);
        }
        return this.configProvider;
    }

    public void doInitialize(ClassLoader coreLoader) {
        this.baseControl = new KarafBaseControl();
        this.logFactory = new JavaLoggerFactory();
        this.mlogFactory = new SingleMLogInstanceFactory();
        this.getBaseControl().getCurrentBase().addObject(MLogFactory.class, (Object)this.mlogFactory);
        this.getCfgManager();
        try {
            this.housekeeper = new KarafHousekeeper();
            this.getBaseControl().getCurrentBase().addObject(MHousekeeper.class, (Object)this.housekeeper);
        }
        catch (Throwable t) {
            System.out.println("Can't initialize housekeeper base: " + t);
        }
        this.getCfgManager().reConfigure();
    }

    public boolean isTrace(String name) {
        return this.fullTrace || this.logTrace.contains(name);
    }

    public void setFullTrace(boolean trace) {
        this.fullTrace = trace;
    }

    public void setTrace(String name) {
        this.logTrace.add(name);
    }

    public void clearTrace() {
        this.logTrace.clear();
    }

    public String[] getTraceNames() {
        return this.logTrace.toArray(new String[this.logTrace.size()]);
    }

    public boolean isFullTrace() {
        return this.fullTrace;
    }

    public Base base() {
        return this.getBaseControl().getCurrentBase();
    }

    public void setLogFactory(LogFactory logFactory) {
        this.logFactory = logFactory;
    }

    public Set<String> getLogTrace() {
        return this.logTrace;
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
        this.baseDir.mkdirs();
    }

    public File getFile(String dir) {
        return new File(this.baseDir, dir);
    }

    public String getSystemProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null) {
            switch (name) {
                case "mhus.lib.config.file": {
                    return "etc/" + def;
                }
                case "timer.config.file": {
                    return "etc/" + def;
                }
            }
            return def;
        }
        return value;
    }

    public synchronized Log lookupLog(Object owner) {
        if (this.mlogFactory == null) {
            this.mlogFactory = (MLogFactory)MApi.lookup(MLogFactory.class);
        }
        return this.mlogFactory.lookup(owner);
    }

    public void updateLog() {
        if (this.mlogFactory == null) {
            return;
        }
        this.mlogFactory.update();
    }

    public void setMLogFactory(MLogFactory mlogFactory) {
        this.mlogFactory = mlogFactory;
    }
}

