/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.mutable;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.schedule.IntervalJob;
import de.mhus.lib.core.schedule.SchedulerJob;
import java.lang.ref.WeakReference;

public class KarafHousekeeper
extends MObject
implements MHousekeeper {
    public void register(MHousekeeperTask task, long sleep, boolean weak) {
        this.log().d(new Object[]{"register", task, sleep, weak});
        TimerIfc timer = (TimerIfc)MApi.lookup(TimerIfc.class);
        if (weak) {
            WeakObserver t = new WeakObserver(task);
            IntervalJob job = new IntervalJob(sleep, (ITimerTask)t);
            t.setJob(job);
            timer.schedule((SchedulerJob)job);
        } else {
            timer.schedule((SchedulerJob)new IntervalJob(sleep, (ITimerTask)task));
        }
    }

    private static class WeakObserver
    implements ITimerTask {
        private WeakReference<MHousekeeperTask> task;
        private IntervalJob job;

        public WeakObserver(MHousekeeperTask task) {
            this.task = new WeakReference<MHousekeeperTask>(task);
        }

        public void setJob(IntervalJob job) {
            this.job = job;
        }

        public void run(Object arg) {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                this.job.cancel();
            } else {
                t.run(arg);
            }
        }

        public String toString() {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                return super.toString();
            }
            return t.toString();
        }

        public String getName() {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                return "[removed]";
            }
            return t.getName();
        }

        public void onError(Throwable e) {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                this.job.cancel();
            } else {
                t.onError(e);
            }
        }

        public void onFinal(boolean isError) {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                this.job.cancel();
            } else {
                t.onFinal(isError);
            }
        }

        public boolean isCanceled() {
            MHousekeeperTask t = (MHousekeeperTask)this.task.get();
            if (t == null) {
                return true;
            }
            return t.isCanceled();
        }
    }
}

