/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.mutable;

import de.mhus.lib.core.lang.Base;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.system.DefaultBase;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class KarafBase
extends DefaultBase {
    private static HashMap<String, Container> apiCache = new HashMap();

    public KarafBase(Base parent) {
        super(parent);
    }

    public <T, D extends T> T lookup(Class<T> ifc, Class<D> def) {
        if (ifc == null) {
            return null;
        }
        if (def == null && ifc.isInterface()) {
            ServiceReference ref;
            BundleContext context;
            Bundle bundle;
            Container cached = apiCache.get(ifc.getCanonicalName());
            if (cached != null && (cached.bundle.getState() != 32 || cached.modified != cached.bundle.getLastModified())) {
                apiCache.remove(cached.ifc.getCanonicalName());
                cached = null;
            }
            if (cached == null && (bundle = FrameworkUtil.getBundle(KarafBase.class)) != null && (context = bundle.getBundleContext()) != null && (ref = context.getServiceReference(ifc)) != null) {
                if (ref.getBundle().getState() != 32) {
                    MLogUtil.log().d(new Object[]{"KarafBase", "found in bundle but not jet active", ifc, bundle.getSymbolicName()});
                    return null;
                }
                Object obj = null;
                try {
                    obj = ref.getBundle().getBundleContext().getService(ref);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (obj != null) {
                    MLogUtil.log().d(new Object[]{"KarafBase", "loaded from OSGi", ifc});
                    cached = new Container();
                    cached.bundle = ref.getBundle();
                    cached.api = obj;
                    cached.ifc = ifc;
                    cached.modified = cached.bundle.getLastModified();
                    apiCache.put(ifc.getCanonicalName(), cached);
                }
            }
            if (cached != null) {
                return (T)cached.api;
            }
        }
        return (T)super.lookup(ifc, def);
    }

    public void clearCache() {
        apiCache.clear();
    }

    public void dumpCache(PrintStream out) {
        for (Map.Entry<String, Container> item : apiCache.entrySet()) {
            out.println(item.getKey() + ": " + item.getValue().ifc);
            out.println("  Bundle: " + item.getValue().bundle.getSymbolicName() + " " + item.getValue().bundle.getState());
            out.println("  Object: " + item.getValue().api);
        }
    }

    private static class Container {
        public long modified;
        public Class<?> ifc;
        public Object api;
        public Bundle bundle;

        private Container() {
        }
    }
}

