/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.services;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import de.mhus.lib.basics.Named;
import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.schedule.CronJob;
import de.mhus.lib.core.schedule.IntervalJob;
import de.mhus.lib.core.schedule.IntervalWithStartTimeJob;
import de.mhus.lib.core.schedule.OnceJob;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.SchedulerTimer;
import de.mhus.lib.core.schedule.TimerTaskAdapter;
import de.mhus.lib.core.schedule.TimerTaskIntercepter;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.MServiceTracker;
import de.mhus.lib.karaf.services.SchedulerService;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@Component(provide={TimerFactory.class}, immediate=true, name="de.mhus.lib.karaf.services.TimerFactoryImpl")
public class TimerFactoryImpl
extends MLog
implements TimerFactory {
    protected static Log log = Log.getLog(TimerFactoryImpl.class);
    private SchedulerTimer myTimer = new SchedulerTimer("de.mhus.lib.karaf.Scheduler");
    private MServiceTracker<SchedulerService> tracker;
    private WeakHashMap<SchedulerService, SchedulerJob> services = new WeakHashMap();
    static TimerFactoryImpl instance;

    @Deactivate
    void doDeactivate(ComponentContext ctx) {
        this.log().i(new Object[]{"cancel common timer"});
        this.tracker.stop();
        this.myTimer.cancel();
        this.myTimer = null;
        instance = null;
    }

    @Activate
    void doActivate(ComponentContext ctx) {
        instance = this;
        this.log().i(new Object[]{"start common timer"});
        this.myTimer.start();
        try {
            TimerWrap timerIfc = new TimerWrap();
            MApi.get().getBaseControl().getCurrentBase().addObject(TimerIfc.class, (Object)timerIfc);
        }
        catch (Throwable t) {
            System.out.println("Can't initialize timer base: " + t);
        }
        BundleContext context = ctx.getBundleContext();
        this.tracker = new MServiceTracker<SchedulerService>(context, SchedulerService.class){

            @Override
            protected void removeService(ServiceReference<SchedulerService> reference, SchedulerService service) {
                TimerFactoryImpl.this.log().d(new Object[]{"remove service", reference.getBundle().getSymbolicName(), reference.getBundle().getBundleId(), MOsgi.getState(reference.getBundle()), service.getClass().getCanonicalName()});
                TimerFactoryImpl.this.removeSchedulerService(service);
            }

            @Override
            protected void addService(ServiceReference<SchedulerService> reference, SchedulerService service) {
                TimerFactoryImpl.this.log().d(new Object[]{"add service", reference.getBundle().getSymbolicName(), reference.getBundle().getBundleId(), MOsgi.getState(reference.getBundle()), service.getClass().getCanonicalName()});
                TimerFactoryImpl.this.addSchedulerService(reference, service);
            }
        }.start();
    }

    protected void addSchedulerService(ServiceReference<SchedulerService> reference, SchedulerService service) {
        Object job = null;
        Object interval = service.getInterval();
        job = service.getWrappedJob();
        if (job == null) {
            if (interval == null) {
                interval = reference.getProperty("interval");
            }
            if (interval == null) {
                this.log().i(new Object[]{"interval configuration not found for SchedulerService", service, reference});
                return;
            }
            String i = String.valueOf(interval);
            if (i.startsWith("once:")) {
                i = i.substring(5);
                long s = 0L;
                s = i.indexOf(45) > 0 || i.indexOf(46) > 0 || i.indexOf(47) > 0 ? MDate.toDate((Object)i, (Date)new Date()).getTime() : System.currentTimeMillis() + MTimeInterval.toTime((String)i, (long)-1L);
                job = new OnceJob(s, (ITimerTask)service);
            } else if (i.startsWith("cron:")) {
                job = new CronJob(i.substring(5), (ITimerTask)service);
            } else if (i.startsWith("interval:")) {
                i = i.substring(9);
                job = this.toIntervalJob(service, i);
            } else {
                job = i.indexOf(32) > 0 ? new CronJob(i, (ITimerTask)service) : this.toIntervalJob(service, i);
            }
        }
        if (job != null) {
            job.setNextExecutionTime(0L);
            job.setInfo(reference.getBundle().getSymbolicName() + " [" + reference.getBundle().getBundleId() + "]");
            TimerTaskIntercepter intercepter = service.getIntercepter();
            if (intercepter != null) {
                job.setIntercepter(intercepter);
            }
            this.services.put(service, (SchedulerJob)job);
            this.myTimer.schedule(job);
        } else {
            this.log().i(new Object[]{"interval configuration syntax error for SchedulerService", service, reference, interval});
        }
    }

    private SchedulerJob toIntervalJob(SchedulerService service, String i) {
        if (i.indexOf(44) > 0) {
            long s = 0L;
            String sStr = MString.beforeIndex((String)i, (char)',');
            s = sStr.indexOf(45) > 0 || sStr.indexOf(46) > 0 || sStr.indexOf(47) > 0 ? MDate.toDate((Object)sStr, (Date)new Date()).getTime() : System.currentTimeMillis() + MTimeInterval.toTime((String)sStr, (long)-1L);
            long l = MTimeInterval.toTime((String)MString.afterIndex((String)i, (char)','), (long)-1L);
            if (s > 0L && l > 0L) {
                return new IntervalWithStartTimeJob(s, l, (ITimerTask)service);
            }
        } else {
            long l = MTimeInterval.toTime((String)i, (long)-1L);
            if (l > 0L) {
                return new IntervalJob(l, (ITimerTask)service);
            }
        }
        return null;
    }

    protected void removeSchedulerService(SchedulerService service) {
        SchedulerJob job = this.services.get(service);
        if (job != null) {
            job.setNextExecutionTime(-2L);
            this.myTimer.getQueue().removeJob(job);
        } else {
            this.log().i(new Object[]{"timer task not found for ScheduledService", service});
        }
    }

    public static SchedulerTimer getScheduler(TimerFactory factory) {
        TimerIfc timer = factory.getTimer();
        if (timer instanceof TimerWrap) {
            return ((TimerWrap)timer).getScheduler();
        }
        return null;
    }

    public TimerIfc getTimer() {
        return new TimerWrap();
    }

    public static void doDebugInfo() {
        for (SchedulerJob job : TimerFactoryImpl.instance.myTimer.getScheduledJobs()) {
            Object task = job.getTask();
            String info = " ";
            if (task instanceof TimerTaskAdapter) {
                task = ((TimerTaskAdapter)task).getTask();
                info = info + "ObserverTimerTaskAdapter ";
            }
            log.i(new Object[]{"JOB", job.getClass(), job.getName(), info, task == null ? "null" : task.getClass()});
        }
    }

    public void stop() {
        this.tracker.stop();
        MThread.sleep((long)1000L);
        this.myTimer.clear();
        this.myTimer.stop();
    }

    public void start() {
        this.myTimer.start();
        this.tracker.start();
    }

    public boolean isRunning() {
        return this.tracker.isRunning();
    }

    public static class ScheduledServiceWrap
    implements SchedulerService {
        private TimerTask task;
        private String interval;
        private String name;

        public ScheduledServiceWrap(Bundle bundle, SchedulerJob job) {
            this.task = job;
        }

        public ScheduledServiceWrap(String name, Bundle bundle, TimerTask task, String interval) {
            this.task = task;
            this.interval = interval;
            this.name = name;
        }

        @Override
        public String getInterval() {
            return this.interval;
        }

        public void run(Object environment) {
            if (this.task instanceof ITimerTask) {
                ((ITimerTask)this.task).run(environment);
            } else {
                this.task.run();
            }
        }

        public void onError(Throwable t) {
            if (this.task instanceof ITimerTask) {
                ((ITimerTask)this.task).onError(t);
            } else {
                t.printStackTrace();
            }
        }

        public void onFinal(boolean isError) {
            if (this.task instanceof ITimerTask) {
                ((ITimerTask)this.task).onFinal(isError);
            }
        }

        public boolean isCanceled() {
            if (this.task instanceof ITimerTask) {
                return ((ITimerTask)this.task).isCanceled();
            }
            return false;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            if (this.task instanceof Named) {
                return ((Named)this.task).getName();
            }
            return MSystem.getClassName(this.task.getClass());
        }

        @Override
        public SchedulerJob getWrappedJob() {
            if (this.task instanceof SchedulerJob) {
                return (SchedulerJob)this.task;
            }
            return null;
        }

        @Override
        public TimerTaskIntercepter getIntercepter() {
            if (this.task instanceof SchedulerJob) {
                return ((SchedulerJob)this.task).getIntercepter();
            }
            return null;
        }
    }

    private class TimerWrap
    implements TimerIfc {
        private TimerWrap() {
        }

        private void createService(String name, TimerTask task, String interval) {
            Bundle caller = FrameworkUtil.getBundle(task.getClass());
            ScheduledServiceWrap service = new ScheduledServiceWrap(name, caller, task, interval);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String n = service.getName();
            properties.put("job.name", n == null ? "?" : n);
            properties.put("job.task", task.getClass());
            properties.put("job.interval", interval);
            properties.put("job.bundle", caller.getSymbolicName());
            properties.put("job.timer", MSystem.getObjectId((Object)this));
            caller.getBundleContext().registerService(SchedulerService.class, (Object)service, properties);
        }

        private void createService(SchedulerJob job) {
            Bundle caller = FrameworkUtil.getBundle(job.getTask() == null ? job.getClass() : job.getTask().getClass());
            ScheduledServiceWrap service = new ScheduledServiceWrap(caller, job);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String n = job.getName();
            properties.put("job.name", n == null ? "?" : n);
            properties.put("job.scheduler", job.getClass());
            properties.put("job.task", job.getTask().getClass());
            properties.put("job.bundle", caller.getSymbolicName());
            properties.put("job.timer", MSystem.getObjectId((Object)this));
            caller.getBundleContext().registerService(SchedulerService.class, (Object)service, properties);
        }

        public SchedulerTimer getScheduler() {
            return TimerFactoryImpl.this.myTimer;
        }

        public void schedule(TimerTask task, long delay) {
            this.createService(null, task, "interval:" + delay);
        }

        public void schedule(TimerTask task, Date time) {
            this.createService(null, task, "once:" + MDate.toIso8601((Date)time));
        }

        public void schedule(TimerTask task, long delay, long period) {
            this.createService(null, task, "interval:" + delay + "," + period);
        }

        public void schedule(TimerTask task, Date firstTime, long period) {
            this.createService(null, task, "interval:" + MDate.toIso8601((Date)firstTime) + "," + period);
        }

        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
            this.schedule(null, task, delay, period);
        }

        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
            this.schedule(null, task, firstTime, period);
        }

        public void schedule(String name, TimerTask task, long delay) {
            this.createService(name, task, "interval:" + delay);
        }

        public void schedule(String name, TimerTask task, Date time) {
            this.createService(name, task, "once:" + MDate.toIso8601((Date)time));
        }

        public void schedule(String name, TimerTask task, long delay, long period) {
            this.createService(name, task, "interval:" + delay + "," + period);
        }

        public void schedule(String name, TimerTask task, Date firstTime, long period) {
            this.createService(name, task, "interval:" + MDate.toIso8601((Date)firstTime) + "," + period);
        }

        public void scheduleAtFixedRate(String name, TimerTask task, long delay, long period) {
            this.schedule(name, task, delay, period);
        }

        public void scheduleAtFixedRate(String name, TimerTask task, Date firstTime, long period) {
            this.schedule(name, task, firstTime, period);
        }

        public void schedule(SchedulerJob job) {
            this.createService(job);
        }

        public void cancel() {
            for (MOsgi.Service<SchedulerService> ref : MOsgi.getServiceRefs(SchedulerService.class, "(job.timer=" + MSystem.getObjectId((Object)this) + ")")) {
                try {
                    ref.getReference().getBundle().getBundleContext().ungetService(ref.getReference());
                }
                catch (Throwable t) {
                    TimerFactoryImpl.this.log().d(new Object[]{"unset SchedulerService", MSystem.getObjectId((Object)this), ref, t});
                }
            }
        }
    }
}

