/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.services;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.StreamToLogAdapter;
import de.mhus.lib.core.schedule.CronJob;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.services.SimpleServiceIfc;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;

public class ScheduleGogo
extends MLog
implements SimpleServiceIfc {
    private String interval;
    private String command;
    private TimerIfc timer;
    private MTimerTask job;
    private String name;

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
        this.log().d(new Object[]{this.name, "get interval", interval});
        this.doInit();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setTimerFactory(TimerFactory factory) {
        this.timer = factory.getTimer();
        this.log().d(new Object[]{this.name, "get timer factory"});
        this.doInit();
    }

    private void doInit() {
        if (this.timer == null || this.interval == null) {
            return;
        }
        if (this.job != null) {
            return;
        }
        this.log().d(new Object[]{this.name, "start", this.interval});
        this.job = new MyJob();
        this.timer.schedule((SchedulerJob)new CronJob(this.interval, (ITimerTask)this.job));
    }

    protected void doExecute() {
        if (this.command == null || this.timer == null) {
            return;
        }
        this.log().i(new Object[]{this.name, "execute", this.command});
        StreamToLogAdapter out = new StreamToLogAdapter(Log.LEVEL.INFO, null);
        StreamToLogAdapter err = new StreamToLogAdapter(Log.LEVEL.ERROR, null);
        try {
            SessionFactory commandProcessor = MOsgi.getService(SessionFactory.class);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
            Session commandSession = commandProcessor.create((InputStream)in, (PrintStream)out, (PrintStream)err);
            commandSession.put("interactive.mode", (Object)false);
            commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
            commandSession.put("USER", (Object)"karaf");
            commandSession.execute((CharSequence)this.command);
        }
        catch (Throwable t) {
            this.log().w(new Object[]{this.name, t});
        }
        out.close();
        err.close();
    }

    public void init() {
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void destroy() {
        if (this.timer != null) {
            this.log().d(new Object[]{this.name, "deactivate"});
            this.timer.cancel();
        }
        this.timer = null;
        this.job = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSimpleServiceInfo() {
        return this.interval;
    }

    @Override
    public String getSimpleServiceStatus() {
        if (this.timer == null) {
            return "no timer";
        }
        if (this.job == null) {
            return "not started";
        }
        return "running";
    }

    @Override
    public void doSimpleServiceCommand(String cmd, Object ... param) {
    }

    private class MyJob
    extends MTimerTask {
        private MyJob() {
        }

        public String getName() {
            return "SchedulerGogo:" + ScheduleGogo.this.name;
        }

        public void doit() {
            ScheduleGogo.this.doExecute();
        }
    }
}

