/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.services;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.OnceJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.SchedulerTimer;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.services.TimerFactoryImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="mhus", name="timer", description="Default Timer Handling")
@Service
public class CmdTimer
extends MLog
implements Action {
    @Argument(index=0, name="cmd", required=true, description="Command to execute list,\n timeout,\n stacktrace,\n timeoutstacktrace,\n done <name> <done>,\n disable/enable/cancel/remove <name>,\n run <name>,\n configure <name> <configuration>\n trail <name> [<trail config>]\n release <name> - hard release the busy lock  name is allways a pattern use * to define placeholders", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-a", aliases={"--all"}, description="return all informations", required=false)
    boolean all = false;

    public Object execute() throws Exception {
        List running;
        Object table;
        List scheduled;
        TimerFactory factory = MOsgi.getService(TimerFactory.class);
        SchedulerTimer scheduler = TimerFactoryImpl.getScheduler(factory);
        if (!TimerFactoryImpl.instance.isRunning()) {
            System.out.println("ServiceTracker is not running!");
        }
        if (this.cmd.equals("jobs")) {
            scheduled = scheduler.getJobs();
            table = new ConsoleTable();
            if (this.all) {
                table.setLineSpacer(true);
            }
            if (this.all) {
                table.setHeaderValues(new String[]{"Name", "Task", "Job", "Info", "Started", "Stopped", "Scheduled/Thread", "Left", "Timeout", "Canceled", "Done", "Status", "Interceptor", "Trail config", "Busy"});
            } else {
                table.setHeaderValues(new String[]{"Name", "Job", "Info", "Started", "Scheduled/Thread", "Left", "Canceled", "Status"});
            }
            for (Object job : scheduled) {
                if (this.all) {
                    table.addRowValues(new Object[]{job.getName(), job.getTask(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), MDate.toIsoDateTime((long)job.getLastExecutionStop()), MDate.toIsoDateTime((long)job.getScheduledTime()), MTimeInterval.getIntervalAsStringSec((long)(job.getScheduledTime() - System.currentTimeMillis())), job.getTimeoutInMinutes(), job.isCanceled(), job.isDone(), this.getStatus((SchedulerJob)job), job.getIntercepter(), job.getLogTrailConfig(), job.isBusy()});
                    continue;
                }
                table.addRowValues(new Object[]{job.getName(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), MDate.toIsoDateTime((long)job.getScheduledTime()), MTimeInterval.getIntervalAsStringSec((long)(job.getScheduledTime() - System.currentTimeMillis())), job.isCanceled(), this.getStatus((SchedulerJob)job)});
            }
            table.print(System.out);
        } else if (this.cmd.equals("list")) {
            scheduled = scheduler.getScheduledJobs();
            List running2 = scheduler.getRunningJobs();
            ConsoleTable table2 = new ConsoleTable();
            if (this.all) {
                table2.setLineSpacer(true);
            }
            if (this.all) {
                table2.setHeaderValues(new String[]{"Name", "Task", "Job", "Info", "Started", "Stopped", "Scheduled/Thread", "Left", "Timeout", "Canceled", "Done", "Status", "Interceptor", "Trail config", "Busy"});
            } else {
                table2.setHeaderValues(new String[]{"Name", "Job", "Info", "Started", "Scheduled/Thread", "Left", "Canceled", "Status"});
            }
            for (Object job : running2) {
                if (this.all) {
                    table2.addRowValues(new Object[]{job.getName(), job.getTask(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), "Running", job.getThread(), "-", job.getTimeoutInMinutes(), job.isCanceled(), job.isDone(), this.getStatus((SchedulerJob)job), job.getIntercepter(), job.getLogTrailConfig(), job.isBusy()});
                    continue;
                }
                table2.addRowValues(new Object[]{job.getName(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), job.getThread(), "-", job.isCanceled(), this.getStatus((SchedulerJob)job)});
            }
            for (Object job : scheduled) {
                if (this.all) {
                    table2.addRowValues(new Object[]{job.getName(), job.getTask(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), MDate.toIsoDateTime((long)job.getLastExecutionStop()), MDate.toIsoDateTime((long)job.getScheduledTime()), MTimeInterval.getIntervalAsStringSec((long)(job.getScheduledTime() - System.currentTimeMillis())), job.getTimeoutInMinutes(), job.isCanceled(), job.isDone(), this.getStatus((SchedulerJob)job), job.getIntercepter(), job.getLogTrailConfig(), job.isBusy()});
                    continue;
                }
                table2.addRowValues(new Object[]{job.getName(), job, job.getInfo(), MDate.toIsoDateTime((long)job.getLastExecutionStart()), MDate.toIsoDateTime((long)job.getScheduledTime()), MTimeInterval.getIntervalAsStringSec((long)(job.getScheduledTime() - System.currentTimeMillis())), job.isCanceled(), this.getStatus((SchedulerJob)job)});
            }
            table2.print(System.out);
        }
        if (this.cmd.equals("timeout")) {
            running = scheduler.getRunningJobs();
            table = new ConsoleTable();
            table.setHeaderValues(new String[]{"Task", "Job", "Started", "Stopped", "Description", "Name", "Scheduled", "Timeout"});
            long time = System.currentTimeMillis();
            for (SchedulerJob job : running) {
                long timeout = job.getTimeoutInMinutes() * 60000L;
                if (timeout <= 0L || timeout + job.getLastExecutionStart() > time) continue;
                table.addRowValues(new Object[]{job.getTask(), job, MDate.toIsoDateTime((long)job.getLastExecutionStart()), "Running", job.getDescription(), job.getName(), "Running", job.getTimeoutInMinutes()});
            }
            table.print(System.out);
        }
        if (this.cmd.equals("stacktrace")) {
            running = scheduler.getRunningJobs();
            for (SchedulerJob job : running) {
                Thread thread = job.getThread();
                if (thread == null) continue;
                StackTraceElement[] stack = thread.getStackTrace();
                System.out.println(MCast.toString((String)(job.getName() + " (threadId=" + thread.getId() + ")"), (StackTraceElement[])stack));
            }
        }
        if (this.cmd.equals("timeoutstacktrace")) {
            running = scheduler.getRunningJobs();
            long time = System.currentTimeMillis();
            for (Object job : running) {
                Thread thread;
                long timeout = job.getTimeoutInMinutes() * 60000L;
                if (timeout <= 0L || timeout + job.getLastExecutionStart() > time || (thread = job.getThread()) == null) continue;
                StackTraceElement[] stack = thread.getStackTrace();
                System.out.println(MCast.toString((String)(job.getName() + " (threadId=" + thread.getId() + ")"), (StackTraceElement[])stack));
            }
        }
        if (this.cmd.equals("dummy")) {
            scheduler.schedule((SchedulerJob)new OnceJob(System.currentTimeMillis() + 60000L, (ITimerTask)new MTimerTask(){

                protected void doit() throws Exception {
                    CmdTimer.this.log().i(new Object[]{">>> Start Dummy"});
                    MThread.sleep((long)120000L);
                    CmdTimer.this.log().i(new Object[]{"<<< Stop Dummy"});
                }
            }){
                {
                    this.setTimeoutInMinutes(1L);
                }

                public void doTimeoutReached() {
                    CmdTimer.this.log().i(new Object[]{"+++ Dummy Timeout Reached"});
                }
            });
        }
        if (this.cmd.equals("schedule")) {
            Date time = MCast.toDate((Object)this.parameters[1], null);
            if (time == null) {
                System.out.println("Malformed time");
                return null;
            }
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null || !(job instanceof MutableSchedulerJob)) continue;
                ((MutableSchedulerJob)job).setScheduledTime(time.getTime());
                System.out.println("OK, Scheduled " + job.getName() + " to " + MDate.toIsoDateTime((Date)time));
            }
        }
        if (this.cmd.equals("done")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null || !(job instanceof MutableSchedulerJob)) continue;
                ((MutableSchedulerJob)job).setDone(MCast.toboolean((Object)this.parameters[1], (boolean)false));
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("remove")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null) continue;
                scheduler.getQueue().removeJob(job);
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("disable")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null || !(job instanceof MutableSchedulerJob)) continue;
                ((MutableSchedulerJob)job).doReschedule((Scheduler)scheduler, -1L);
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("enable")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null || !(job instanceof MutableSchedulerJob)) continue;
                ((MutableSchedulerJob)job).doReschedule((Scheduler)scheduler, 0L);
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("cancel")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null) continue;
                job.cancel();
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("release")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null) continue;
                job.releaseBusy(null);
                System.out.println("OK " + job.getName());
            }
        }
        if (this.cmd.equals("configure")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null || !(job instanceof MutableSchedulerJob)) continue;
                boolean ret = ((MutableSchedulerJob)job).doReconfigure(this.parameters[1]);
                System.out.println("OK " + job.getName() + " " + ret);
                if (!ret) continue;
                ((MutableSchedulerJob)job).doReschedule((Scheduler)scheduler, 0L);
            }
        }
        if (this.cmd.equals("run")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null) continue;
                scheduler.doExecuteJob(job, true);
            }
        }
        if (this.cmd.equals("debug")) {
            TimerFactoryImpl.doDebugInfo();
        }
        if (this.cmd.equals("recreate")) {
            TimerFactoryImpl.instance.stop();
            TimerFactoryImpl.instance.start();
            System.out.println("OK");
        }
        if (this.cmd.equals("start")) {
            TimerFactoryImpl.instance.start();
            System.out.println("OK");
        }
        if (this.cmd.equals("stop")) {
            TimerFactoryImpl.instance.stop();
            System.out.println("OK");
        }
        if (this.cmd.equals("trail")) {
            for (SchedulerJob job : this.getScheduledJob(scheduler, this.parameters[0])) {
                if (job == null) continue;
                System.out.println("Change " + job.getName());
                if (this.parameters.length < 2 || MString.isEmpty((String)this.parameters[1])) {
                    job.setLogTrailConfig(null);
                    continue;
                }
                job.setLogTrailConfig(this.parameters[1]);
            }
        }
        return null;
    }

    private String getStatus(SchedulerJob job) {
        long t = job.getNextExecutionTime();
        if (t == 0L) {
            return "Calculate";
        }
        if (t == -1L) {
            return "Disabled";
        }
        if (t == -2L) {
            return "Remove";
        }
        return "OK";
    }

    private List<SchedulerJob> getScheduledJob(SchedulerTimer scheduler, String jobId) {
        List jobs = scheduler.getScheduledJobs();
        LinkedList<SchedulerJob> out = new LinkedList<SchedulerJob>();
        for (SchedulerJob job : jobs) {
            if (!MString.compareFsLikePattern((String)job.getName(), (String)jobId)) continue;
            out.add(job);
        }
        return out;
    }
}

