/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.services;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.karaf.services.SimpleServiceIfc;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Command(scope="mhus", name="simpleservice", description="Simple Service Interaction")
@Service
public class CmdSimpleService
extends MLog
implements Action {
    @Argument(index=0, name="cmd", required=true, description="list,cmd", multiValued=false)
    String cmd;
    @Argument(index=1, name="service", required=false, description="Service Name", multiValued=false)
    String serviceName;
    @Argument(index=2, name="service cmd", required=false, description="Cmd to the service", multiValued=false)
    String serviceCmd;
    @Argument(index=3, name="paramteters", required=false, description="Parameters", multiValued=true)
    Object[] parameters;

    public Object execute() throws Exception {
        if (this.cmd.equals("list")) {
            ConsoleTable table = new ConsoleTable();
            table.setHeaderValues(new String[]{"Info", "Status"});
            BundleContext context = FrameworkUtil.getBundle(CmdSimpleService.class).getBundleContext();
            for (ServiceReference ref : context.getServiceReferences(SimpleServiceIfc.class, null)) {
                SimpleServiceIfc service = (SimpleServiceIfc)context.getService(ref);
                table.addRowValues(new Object[]{service.getSimpleServiceInfo(), service.getSimpleServiceStatus()});
            }
            table.print(System.out);
        } else if (this.cmd.equals("cmd")) {
            BundleContext context = FrameworkUtil.getBundle(CmdSimpleService.class).getBundleContext();
            for (ServiceReference ref : context.getServiceReferences(SimpleServiceIfc.class, null)) {
                SimpleServiceIfc service = (SimpleServiceIfc)context.getService(ref);
                if (!this.serviceName.equals(service.getSimpleServiceInfo())) continue;
                System.out.println("CMD " + this.serviceCmd);
                service.doSimpleServiceCommand(this.serviceCmd, this.parameters);
            }
        }
        return null;
    }
}

