/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.services;

import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.services.CacheControlIfc;
import de.mhus.lib.karaf.services.CacheControlUtil;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="mhus", name="cache", description="Cache Control Service Control")
@Service
public class CmdCacheControl
extends MJmx
implements Action {
    @Argument(index=0, name="cmd", required=true, description="list,clear", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;

    public Object execute() throws Exception {
        if (this.cmd.equals("list")) {
            ConsoleTable table = new ConsoleTable();
            table.setHeaderValues(new String[]{"Name", "Size", "Enabled", "Status"});
            for (CacheControlIfc c : MOsgi.getServices(CacheControlIfc.class, null)) {
                try {
                    table.addRowValues(new Object[]{c.getName(), c.getSize(), c.isEnabled(), "ok"});
                }
                catch (Throwable t) {
                    this.log().d(new Object[]{c, t});
                    table.addRowValues(new Object[]{c.getName(), "?", "?", t.toString()});
                }
            }
            table.print(System.out);
        } else if (this.cmd.equals("clear")) {
            String name = null;
            if (this.parameters != null && this.parameters.length > 0) {
                name = this.parameters[0];
            }
            CacheControlUtil.clear(name);
            System.out.println("OK");
        } else if (this.cmd.equals("enable")) {
            String name = null;
            if (this.parameters != null && this.parameters.length > 0) {
                name = this.parameters[0];
            }
            CacheControlUtil.enable(name, true);
            System.out.println("OK");
        } else if (this.cmd.equals("disable")) {
            String name = null;
            if (this.parameters != null && this.parameters.length > 0) {
                name = this.parameters[0];
            }
            CacheControlUtil.enable(name, false);
            System.out.println("OK");
        }
        return null;
    }
}

