/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms.heartbeat;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import aQute.bnd.annotation.component.Reference;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.jms.JmsDataSource;
import de.mhus.lib.karaf.jms.JmsManagerService;
import de.mhus.lib.karaf.jms.JmsUtil;
import de.mhus.lib.karaf.jms.heartbeat.HeartbeatAdmin;
import de.mhus.lib.karaf.jms.heartbeat.HeartbeatService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.osgi.service.component.ComponentContext;

@Component(provide={HeartbeatAdmin.class}, immediate=true, name="de.mhus.lib.karaf.jms.heartbeat.HeartbeatAdmin")
public class HeartbeatAdminImpl
extends MLog
implements HeartbeatAdmin {
    private TimerIfc timer;
    private HashMap<String, HeartbeatService> services = new HashMap();
    private boolean enabled = true;
    private MTimerTask timerTask;

    @Activate
    public void doActivate(ComponentContext ctx) {
    }

    @Reference(service=TimerFactory.class)
    public void setTimerFactory(TimerFactory factory) {
        this.log().i(new Object[]{"create timer"});
        this.timer = factory.getTimer();
        this.timerTask = new MTimerTask(){

            public void doit() throws Exception {
                if (!HeartbeatAdminImpl.this.enabled) {
                    return;
                }
                HeartbeatAdminImpl.this.sendHeartbeat(null);
            }
        };
        this.timer.schedule((TimerTask)this.timerTask, 10000L, 300000L);
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendHeartbeat(String cmd) {
        HashMap<String, HeartbeatService> hashMap = this.services;
        synchronized (hashMap) {
            JmsManagerService jmsService = JmsUtil.getService();
            if (jmsService == null) {
                return;
            }
            List<MOsgi.Service<JmsDataSource>> conList = jmsService.getDataSources();
            HashSet<String> existList = new HashSet<String>();
            existList.addAll(this.services.keySet());
            for (MOsgi.Service<JmsDataSource> src : conList) {
                String conName = src.getService().getName();
                try {
                    HeartbeatService service = this.services.get(conName);
                    if (service == null) {
                        this.log().i(new Object[]{"create", conName});
                        service = new HeartbeatService();
                        service.setName(service.getName() + ":" + conName);
                        service.setConnectionName(conName);
                        jmsService.addChannel(service);
                        this.services.put(conName, service);
                        service.doTimerTask(cmd);
                    } else if (!service.getChannel().isClosed()) {
                        service.doTimerTask(cmd);
                    }
                }
                catch (Throwable t) {
                    this.log().d(new Object[]{conName, t});
                }
                existList.remove(conName);
            }
            for (String conName : existList) {
                this.log().i(new Object[]{"remove", conName});
                HeartbeatService service = this.services.get(conName);
                jmsService.removeChannel(service.getName());
            }
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<HeartbeatService> getServices() {
        return new LinkedList<HeartbeatService>(this.services.values());
    }
}

