/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms.heartbeat;

import de.mhus.lib.karaf.jms.JmsUtil;
import de.mhus.lib.karaf.jms.heartbeat.HeartbeatAdmin;
import de.mhus.lib.karaf.jms.heartbeat.HeartbeatService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Command(scope="jms", name="heartbeat", description="Send heardbeat")
@Service
public class CmdHeartbeat
implements Action {
    @Argument(index=0, name="cmd", required=false, description="enable / disable, reset", multiValued=false)
    String cmd;

    public Object execute() throws Exception {
        HeartbeatAdmin service = this.getService();
        if (service == null) {
            System.out.println("Service not found");
            return null;
        }
        if ("list".equals(this.cmd)) {
            for (HeartbeatService s : service.getServices()) {
                System.out.println(s.getName());
            }
        } else if ("enable".equals(this.cmd) || "disbale".equals(this.cmd)) {
            service.setEnabled("enable".equals(this.cmd));
            System.out.println("OK " + this.cmd);
        } else {
            System.out.println("Send Heartbeat ...");
            service.sendHeartbeat(this.cmd);
            System.out.println("OK " + this.cmd);
        }
        return null;
    }

    private HeartbeatAdmin getService() {
        BundleContext bc = FrameworkUtil.getBundle(JmsUtil.class).getBundleContext();
        if (bc == null) {
            return null;
        }
        ServiceReference ref = bc.getServiceReference(HeartbeatAdmin.class);
        if (ref == null) {
            return null;
        }
        HeartbeatAdmin obj = (HeartbeatAdmin)bc.getService(ref);
        return obj;
    }
}

