/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import aQute.bnd.annotation.component.Reference;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.lib.jms.JmsConnection;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.jms.JmsDataChannel;
import de.mhus.lib.karaf.jms.JmsDataSource;
import de.mhus.lib.karaf.jms.JmsManagerService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.WeakHashMap;
import javax.jms.JMSException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(name="JmsManagerService", immediate=true)
public class JmsManagerServiceImpl
extends MLog
implements JmsManagerService {
    static JmsManagerService instance;
    private ServiceTracker<JmsDataSource, JmsDataSource> connectionTracker;
    private ServiceTracker<JmsDataChannel, JmsDataChannel> channelTracker;
    private WeakHashMap<String, JmsDataChannel> channels = new WeakHashMap();
    private HashSet<String> connectionNames = new HashSet();
    private BundleContext context;
    private TimerIfc timer;
    private MTimerTask timerTask;
    protected boolean enabled = true;

    @Activate
    public void doActivate(ComponentContext ctx) {
        this.log().i(new Object[]{"activate"});
        instance = this;
        this.context = ctx.getBundleContext();
        this.connectionTracker = new ServiceTracker(this.context, JmsDataSource.class, (ServiceTrackerCustomizer)new MyConnectionTrackerCustomizer());
        this.connectionTracker.open();
        this.channelTracker = new ServiceTracker(this.context, JmsDataChannel.class, (ServiceTrackerCustomizer)new MyChannelTrackerCustomizer());
        this.channelTracker.open();
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.channelTracker != null) {
            this.channelTracker.close();
        }
        if (this.connectionTracker != null) {
            this.connectionTracker.close();
        }
        for (String name : new LinkedList<String>(this.channels.keySet())) {
            this.removeChannel(name);
        }
        instance = null;
    }

    @Reference(service=TimerFactory.class)
    public void setTimerFactory(TimerFactory factory) {
        this.log().i(new Object[]{"create timer"});
        this.timer = factory.getTimer();
        this.timerTask = new MTimerTask(){

            public void doit() throws Exception {
                if (!JmsManagerServiceImpl.this.enabled) {
                    return;
                }
                JmsManagerServiceImpl.this.doBeat();
                JmsManagerServiceImpl.this.doChannelBeat();
            }
        };
        this.timer.schedule((TimerTask)this.timerTask, 60000L, 60000L);
    }

    @Override
    public void doBeat() {
        String name;
        for (JmsDataSource con : MOsgi.getServices(JmsDataSource.class, null)) {
            name = con.getName();
            if (name == null || this.connectionNames.contains(name)) continue;
            try {
                this.addConnection(name, con.getConnection());
            }
            catch (Throwable e) {
                this.log().d(new Object[]{name, e});
            }
        }
        for (JmsDataChannel c : MOsgi.getServices(JmsDataChannel.class, null)) {
            name = c.getName();
            if (name == null || this.channels.containsKey(name)) continue;
            try {
                this.addChannel(c);
            }
            catch (Throwable e) {
                this.log().d(new Object[]{name, e});
            }
        }
    }

    @Override
    public List<JmsConnection> getConnections() {
        LinkedList<JmsConnection> out = new LinkedList<JmsConnection>();
        for (JmsDataSource obj : MOsgi.getServices(JmsDataSource.class, null)) {
            try {
                out.add(obj.getConnection());
            }
            catch (JMSException e) {
                this.log().w(new Object[]{e});
            }
        }
        return out;
    }

    @Override
    public List<MOsgi.Service<JmsDataSource>> getDataSources() {
        LinkedList<MOsgi.Service<JmsDataSource>> out = new LinkedList<MOsgi.Service<JmsDataSource>>();
        for (MOsgi.Service<JmsDataSource> obj : MOsgi.getServiceRefs(JmsDataSource.class, null)) {
            out.add(obj);
        }
        return out;
    }

    @Override
    public JmsConnection getConnection(String name) {
        if (name == null) {
            return null;
        }
        try {
            JmsDataSource src = MOsgi.getService(JmsDataSource.class, "(osgi.jndi.service.name=jms_" + name + ")");
            if (src == null) {
                return null;
            }
            return src.getConnection();
        }
        catch (NotFoundException nfe) {
            for (MOsgi.Service<JmsDataSource> c : this.getDataSources()) {
                if (c.getService() == null || !name.equals(c.getService().getName())) continue;
                try {
                    return c.getService().getConnection();
                }
                catch (JMSException e) {
                    this.log().w(new Object[]{name, e});
                }
            }
            return null;
        }
        catch (JMSException e) {
            this.log().w(new Object[]{name, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetChannels() {
        WeakHashMap<String, JmsDataChannel> weakHashMap = this.channels;
        synchronized (weakHashMap) {
            List<JmsDataChannel> channels = this.getChannels();
            for (JmsDataChannel channel : channels) {
                try {
                    channel.reset();
                }
                catch (Throwable t) {
                    this.log().t(new Object[]{channel.getName(), t});
                }
            }
        }
    }

    @Override
    public JmsDataChannel getChannel(String name) {
        try {
            return MOsgi.getService(JmsDataChannel.class, "(osgi.jndi.service.name=jmschannel_" + name + ")");
        }
        catch (NotFoundException nfe) {
            for (JmsDataChannel c : this.getChannels()) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
            return this.channels.get(name);
        }
    }

    public void removeConnection(String name) {
        if (name == null) {
            return;
        }
        this.log().d(new Object[]{"remove connection", name});
        this.connectionNames.remove(name);
        for (JmsDataChannel c : new LinkedList<JmsDataChannel>(this.channels.values())) {
            if (!name.equals(c.getConnectionName())) continue;
            try {
                c.onDisconnect();
            }
            catch (Throwable t) {
                this.log().w(new Object[]{name, c, t});
            }
        }
    }

    public void addConnection(String name, JmsConnection connection) {
        if (name == null) {
            return;
        }
        this.log().d(new Object[]{"add connection", name});
        this.connectionNames.add(name);
        for (JmsDataChannel c : new LinkedList<JmsDataChannel>(this.channels.values())) {
            if (!name.equals(c.getConnectionName())) continue;
            try {
                c.onConnect();
            }
            catch (Throwable t) {
                this.log().w(new Object[]{name, c, t});
            }
        }
    }

    @Override
    public List<JmsDataChannel> getChannels() {
        LinkedList<JmsDataChannel> out = new LinkedList<JmsDataChannel>();
        out.addAll(this.channels.values());
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChannelBeat() {
        WeakHashMap<String, JmsDataChannel> weakHashMap = this.channels;
        synchronized (weakHashMap) {
            for (JmsDataChannel c : new LinkedList<JmsDataChannel>(this.channels.values())) {
                try {
                    c.doBeat();
                }
                catch (Throwable t) {
                    this.log().d(new Object[]{c, t});
                }
            }
        }
    }

    @Override
    public String getServiceName(MOsgi.Service<JmsDataSource> ref) {
        Object p = ref.getReference().getProperty("osgi.jndi.service.name");
        if (p != null && p instanceof String && ((String)p).length() > 4 && ((String)p).startsWith("jms_")) {
            return ((String)p).substring(4);
        }
        return null;
    }

    @Override
    public void addChannel(JmsDataChannel channel) {
        this.log().d(new Object[]{"add channel", channel.getName()});
        this.channels.put(channel.getName(), channel);
        channel.onConnect();
    }

    @Override
    public void removeChannel(String name) {
        this.log().d(new Object[]{"remove channel", name});
        JmsDataChannel c = this.channels.remove(name);
        if (c != null) {
            c.onDisconnect();
        }
    }

    @Override
    public void resetConnection(String name) {
        if (name == null) {
            return;
        }
        this.log().d(new Object[]{"reset connection", name});
        for (JmsDataChannel c : new LinkedList<JmsDataChannel>(this.channels.values())) {
            if (!name.equals(c.getConnectionName())) continue;
            try {
                c.onDisconnect();
            }
            catch (Throwable t) {
                this.log().w(new Object[]{name, c, t});
            }
        }
    }

    private class MyChannelTrackerCustomizer
    implements ServiceTrackerCustomizer<JmsDataChannel, JmsDataChannel> {
        private MyChannelTrackerCustomizer() {
        }

        public JmsDataChannel addingService(ServiceReference<JmsDataChannel> reference) {
            try {
                JmsDataChannel service = (JmsDataChannel)JmsManagerServiceImpl.this.context.getService(reference);
                if (service != null) {
                    JmsManagerServiceImpl.this.addChannel(service);
                }
                return service;
            }
            catch (Throwable t) {
                JmsManagerServiceImpl.this.log().e(new Object[]{reference, t});
                return null;
            }
        }

        public void modifiedService(ServiceReference<JmsDataChannel> reference, JmsDataChannel service) {
            JmsManagerServiceImpl.this.removeChannel(service.getName());
            JmsManagerServiceImpl.this.addChannel(service);
        }

        public void removedService(ServiceReference<JmsDataChannel> reference, JmsDataChannel service) {
            JmsManagerServiceImpl.this.removeChannel(service.getName());
        }
    }

    private class MyConnectionTrackerCustomizer
    implements ServiceTrackerCustomizer<JmsDataSource, JmsDataSource> {
        private MyConnectionTrackerCustomizer() {
        }

        public JmsDataSource addingService(ServiceReference<JmsDataSource> reference) {
            JmsDataSource service = (JmsDataSource)JmsManagerServiceImpl.this.context.getService(reference);
            try {
                JmsManagerServiceImpl.this.addConnection(service.getName(), service.createConnection());
            }
            catch (JMSException e) {
                JmsManagerServiceImpl.this.log().t(new Object[]{e});
            }
            JmsManagerServiceImpl.this.resetChannels();
            return service;
        }

        public void modifiedService(ServiceReference<JmsDataSource> reference, JmsDataSource service) {
            JmsManagerServiceImpl.this.removeConnection(service.getName());
            try {
                JmsManagerServiceImpl.this.addConnection(service.getName(), service.createConnection());
            }
            catch (JMSException e) {
                JmsManagerServiceImpl.this.log().t(new Object[]{e});
            }
            JmsManagerServiceImpl.this.resetChannels();
        }

        public void removedService(ServiceReference<JmsDataSource> reference, JmsDataSource service) {
            JmsManagerServiceImpl.this.removeConnection(service.getName());
            JmsManagerServiceImpl.this.resetChannels();
        }
    }
}

