/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.jms.JmsConnection;
import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.jms.JmsDataSource;
import de.mhus.lib.karaf.jms.JmsManagerService;
import de.mhus.lib.karaf.jms.JmsUtil;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jms", name="connection-list", description="Remove connection")
@Service
public class CmdConnectionList
implements Action {
    public Object execute() throws Exception {
        JmsManagerService service = JmsUtil.getService();
        if (service == null) {
            System.out.println("Service not found");
            return null;
        }
        ConsoleTable table = new ConsoleTable();
        table.setHeaderValues(new String[]{"Id", "Name", "Url", "User", "Connected", "Closed"});
        for (MOsgi.Service<JmsDataSource> ref : service.getDataSources()) {
            try {
                JmsConnection con = ref.getService().getConnection();
                String name = service.getServiceName(ref);
                table.addRowValues(new Object[]{name, ref.getService().getName(), con.getUrl(), con.getUser(), con.isConnected(), con.isClosed()});
            }
            catch (Throwable throwable) {}
        }
        table.print(System.out);
        return null;
    }
}

