/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import de.mhus.lib.karaf.jms.JmsManagerService;
import de.mhus.lib.karaf.jms.JmsUtil;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jms", name="channel-beat", description="Reconnect channel")
@Service
public class CmdChannelBeat
implements Action {
    @Argument(index=0, name="name", required=false, description="ID of the channel", multiValued=false)
    String name;

    public Object execute() throws Exception {
        JmsManagerService service = JmsUtil.getService();
        if (service == null) {
            System.out.println("Service not found");
            return null;
        }
        if (this.name == null || this.name.equals("*")) {
            service.doChannelBeat();
        } else {
            if (service.getChannel(this.name).getChannel() == null) {
                service.getChannel(this.name).reset();
            }
            service.getChannel(this.name).getChannel().doBeat();
        }
        System.out.println("OK");
        return null;
    }
}

