/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import de.mhus.lib.karaf.TemplateUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jms", name="channel-add", description="add channel")
@Service
public class CmdChannelAdd
implements Action {
    @Argument(index=0, name="name", required=true, description="ID of the channel", multiValued=false)
    String name;
    @Argument(index=1, name="connection", required=true, description="ID of the connection", multiValued=false)
    String connection;
    @Argument(index=2, name="destination", required=true, description="Name of the destination queue or topic", multiValued=false)
    String destination;
    @Argument(index=3, name="interface", required=true, description="Interface or Implementation", multiValued=false)
    String ifc;
    @Option(name="-t", aliases={"--topic"}, description="Destinantion is a topic", required=false, multiValued=false)
    boolean topic;
    @Option(name="-s", aliases={"--service"}, description="Channel is a service, not a client", required=false, multiValued=false)
    boolean service;

    public Object execute() throws Exception {
        File karafBase = new File(System.getProperty("karaf.base"));
        File deployFolder = new File(karafBase, "deploy");
        File outFile = new File(deployFolder, "jms-channel_" + this.name + ".xml");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connection", this.connection);
        properties.put("destination", this.destination);
        properties.put("topic", String.valueOf(this.topic));
        properties.put("interface", this.service ? "" : this.ifc);
        properties.put("implementation", this.service ? this.ifc : "");
        properties.put("name", this.name);
        String templateFile = "jms-channel.xml";
        InputStream is = this.getClass().getResourceAsStream(templateFile);
        if (is == null) {
            throw new IllegalArgumentException("Template resource " + templateFile + " doesn't exist");
        }
        TemplateUtils.createFromTemplate(outFile, is, properties);
        return null;
    }
}

