/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.jms.JmsChannel;
import de.mhus.lib.jms.JmsConnection;
import de.mhus.lib.karaf.jms.JmsDataChannel;
import de.mhus.lib.karaf.jms.JmsManagerService;
import de.mhus.lib.karaf.jms.JmsUtil;
import javax.jms.JMSException;

public abstract class AbstractJmsDataChannel
extends MLog
implements JmsDataChannel {
    private JmsChannel channel;
    protected String name = this.getClass().getSimpleName();
    protected String connectionName;

    @Override
    public JmsChannel getChannel() {
        try {
            this.checkChannel();
        }
        catch (JMSException e) {
            this.log().d(new Object[]{this.getName(), this.getConnectionName(), e});
        }
        return this.channel;
    }

    public synchronized void checkChannel() throws JMSException {
        if (this.channel == null) {
            this.channel = this.createChannel();
        }
    }

    protected abstract JmsChannel createChannel() throws JMSException;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void reset() {
        this.log().d(new Object[]{"reset", this.getName(), this.getConnectionName()});
        this.onDisconnect();
        this.channel = null;
        this.onConnect();
    }

    @Override
    public void onConnect() {
        JmsConnection con = JmsUtil.getConnection(this.getConnectionName());
        if (con != null) {
            if (!con.isConnected()) {
                try {
                    con.open();
                }
                catch (JMSException e1) {
                    this.log().w(new Object[]{this.getName(), this.getConnectionName(), e1});
                    return;
                }
            }
            if (!con.isConnected()) {
                this.log().d(new Object[]{"not connected", this.getConnectionName()});
                return;
            }
            if (this.channel == null) {
                try {
                    this.checkChannel();
                    this.channel.getJmsDestination().setConnection(con);
                    this.channel.open();
                }
                catch (JMSException e) {
                    this.log().w(new Object[]{this.getName(), this.getConnectionName(), e});
                }
            } else {
                this.channel.getJmsDestination().setConnection(con);
                try {
                    this.channel.reopen();
                }
                catch (JMSException e) {
                    this.log().w(new Object[]{this.getName(), this.getConnectionName(), e});
                }
            }
        } else {
            this.log().d(new Object[]{"connection not found", this.getName(), this.getConnectionName()});
        }
    }

    @Override
    public void onDisconnect() {
        if (this.channel == null) {
            return;
        }
        this.channel.close();
    }

    @Override
    public void doBeat() {
        if (this.channel == null || this.channel.isClosed()) {
            this.onConnect();
            this.channel.isConnected();
        } else if (!this.channel.isClosed() && !this.channel.isConnected()) {
            ((JmsManagerService)MApi.lookup(JmsManagerService.class)).resetConnection(this.getConnectionName());
            this.onConnect();
        }
    }
}

