/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.DbManagerJdbc;
import de.mhus.lib.adb.DbSchema;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.activator.DefaultActivator;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import de.mhus.lib.sql.DataSourceProvider;
import de.mhus.lib.sql.DbPool;
import de.mhus.lib.sql.DbProvider;
import de.mhus.lib.sql.DefaultDbPool;
import de.mhus.lib.sql.Dialect;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class DbManagerServiceImpl
extends MLog
implements DbManagerService {
    protected DataSourceUtil util;
    private String dataSourceName;
    private DbManager manager;

    protected void doOpen(boolean clean) throws MException {
        if (this.manager != null) {
            return;
        }
        this.doInitialize();
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.util = new DataSourceUtil(context);
        if (this.getDataSource() == null) {
            return;
        }
        this.manager = this.doCreateDbManager(clean);
        this.doPostOpen();
    }

    protected void doPostOpen() throws MException {
    }

    @Override
    public void doClose() {
        if (this.manager == null) {
            return;
        }
        this.manager.getPool().close();
        this.manager = null;
    }

    protected DbManager doCreateDbManager(boolean clean) throws MException {
        DbPool pool = this.doCreateDataPool();
        DbSchema schema = this.doCreateSchema();
        return new DbManagerJdbc(this.dataSourceName, pool, schema, clean);
    }

    protected abstract DbSchema doCreateSchema();

    protected DbPool doCreateDataPool() {
        return new DefaultDbPool((DbProvider)new DataSourceProvider(this.getDataSource(), this.doCreateDialect(), this.doCreateConfig(), this.doCreateActivator()));
    }

    protected MActivator doCreateActivator() {
        try {
            return new DefaultActivator(null, this.getClass().getClassLoader());
        }
        catch (MException e) {
            this.log().e(new Object[]{e});
            return null;
        }
    }

    protected IConfig doCreateConfig() {
        return null;
    }

    protected Dialect doCreateDialect() {
        return null;
    }

    protected DataSource getDataSource() {
        DataSource ds = this.util.getDataSource(this.dataSourceName);
        if (ds == null) {
            this.log().w(new Object[]{"DataSource is unknown", this.dataSourceName});
        }
        return ds;
    }

    @Override
    public void updateManager(boolean clean) throws MException {
        this.doClose();
        if (this.getDataSource() == null) {
            return;
        }
        this.doOpen(clean);
    }

    @Override
    public DbManager getManager() {
        try {
            this.doOpen(false);
        }
        catch (Exception e) {
            this.log().d(new Object[]{e});
        }
        return this.manager;
    }

    @Override
    public boolean isConnected() {
        return this.manager != null;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDataSourceName(String dataSourceName) {
        if (MSystem.equals((Object)this.dataSourceName, (Object)dataSourceName)) {
            return;
        }
        this.dataSourceName = dataSourceName;
        try {
            this.updateManager(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getServiceName() {
        return this.getClass().getSimpleName();
    }
}

