/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.karaf.adb.DbManagerAdmin;
import de.mhus.lib.karaf.adb.DbManagerService;
import java.util.LinkedList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(provide={DbManagerAdmin.class}, immediate=true, name="de.mhus.lib.karaf.adb.DbManagerAdmin")
public class DbManagerAdminImpl
extends MJmx
implements DbManagerAdmin {
    private LinkedList<DbManagerService> services = new LinkedList();
    private ServiceTracker<DbManagerService, DbManagerService> tracker;
    private BundleContext context;

    @Activate
    public void doActivate(ComponentContext ctx) {
        this.context = ctx.getBundleContext();
        this.tracker = new ServiceTracker(this.context, DbManagerService.class, (ServiceTrackerCustomizer)new MyTrackerCustomizer());
        this.tracker.open();
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        this.tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbManagerService[] getServices() {
        LinkedList<DbManagerService> linkedList = this.services;
        synchronized (linkedList) {
            return this.services.toArray(new DbManagerService[this.services.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(DbManagerService service) throws Exception {
        if (service == null) {
            return;
        }
        service.doInitialize();
        LinkedList<DbManagerService> linkedList = this.services;
        synchronized (linkedList) {
            this.services.add(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(DbManagerService service) {
        if (service == null) {
            return;
        }
        LinkedList<DbManagerService> linkedList = this.services;
        synchronized (linkedList) {
            this.services.remove(service);
        }
        try {
            service.doClose();
        }
        catch (Throwable t) {
            this.log().e(new Object[]{t});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbManagerService getService(String name) {
        if (name == null) {
            return null;
        }
        LinkedList<DbManagerService> linkedList = this.services;
        synchronized (linkedList) {
            for (DbManagerService service : this.services) {
                if (!name.equals(service.getServiceName())) continue;
                return service;
            }
        }
        return null;
    }

    private class MyTrackerCustomizer
    implements ServiceTrackerCustomizer<DbManagerService, DbManagerService> {
        private MyTrackerCustomizer() {
        }

        public DbManagerService addingService(ServiceReference<DbManagerService> reference) {
            DbManagerService service = (DbManagerService)DbManagerAdminImpl.this.context.getService(reference);
            try {
                DbManagerAdminImpl.this.addService(service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return service;
        }

        public void modifiedService(ServiceReference<DbManagerService> reference, DbManagerService service) {
        }

        public void removedService(ServiceReference<DbManagerService> reference, DbManagerService service) {
            DbManagerAdminImpl.this.removeService(service);
        }
    }
}

