/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.Persistable;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.errors.MException;
import de.mhus.lib.karaf.adb.DbManagerAdmin;
import de.mhus.lib.karaf.adb.DbManagerService;
import java.io.IOException;
import java.sql.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AdbUtilKaraf {
    public static Class<? extends Persistable> getType(DbManagerService service, String typeName) throws IOException {
        for (Class item : service.getManager().getSchema().getObjectTypes()) {
            if (!item.getSimpleName().equals(typeName)) continue;
            return item;
        }
        throw new IOException("Type not found in service: " + typeName);
    }

    public static String getTableName(DbManagerService service, String typeName) throws IOException {
        typeName = typeName.toLowerCase();
        for (Class item : service.getManager().getSchema().getObjectTypes()) {
            if (!item.getSimpleName().toLowerCase().equals(typeName)) continue;
            return item.getCanonicalName();
        }
        throw new IOException("Type not found in service: " + typeName);
    }

    public static String getTableName(DbManagerService service, Class<?> type) throws IOException {
        for (Class item : service.getManager().getSchema().getObjectTypes()) {
            if (!item.getName().equals(type.getName())) continue;
            return item.getCanonicalName();
        }
        throw new IOException("Type not found in service: " + type);
    }

    public static DbManagerAdmin getAdmin() {
        BundleContext context = FrameworkUtil.getBundle(AdbUtilKaraf.class).getBundleContext();
        ServiceReference adminRef = context.getServiceReference(DbManagerAdmin.class);
        if (adminRef == null) {
            return null;
        }
        DbManagerAdmin admin = (DbManagerAdmin)context.getService(adminRef);
        return admin;
    }

    public static List<DbManagerService> getServices(boolean connectedOnly) {
        DbManagerAdmin admin = AdbUtilKaraf.getAdmin();
        LinkedList<DbManagerService> out = new LinkedList<DbManagerService>();
        if (admin != null) {
            for (DbManagerService service : admin.getServices()) {
                if (connectedOnly && !service.isConnected()) continue;
                out.add(service);
            }
        }
        return out;
    }

    public static DbManagerService getService(String serviceName) throws IOException, InvalidSyntaxException {
        int cnt = 0;
        DbManagerAdmin admin = AdbUtilKaraf.getAdmin();
        if (admin != null) {
            for (DbManagerService service : admin.getServices()) {
                if (serviceName.equals("*") || serviceName.equals("*" + cnt) || serviceName.equals(service.getServiceName())) {
                    return service;
                }
                ++cnt;
            }
        }
        throw new IOException("Service not found: " + serviceName);
    }

    public static Object createAttribute(Class<?> type, Object value) {
        if (value == null || value.equals("[null]")) {
            return null;
        }
        if (value.equals("[uuid]")) {
            return UUID.randomUUID();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("[") && str.endsWith("]")) {
                String[] parts = str.substring(1, str.length() - 1).split(",");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = MUri.decode((String)parts[i]);
                }
                value = parts;
            } else {
                value = MUri.decode((String)str);
            }
        }
        if (type == value.getClass()) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return MCast.toint((Object)value, (int)0);
        }
        if (type == Long.TYPE || type == Long.class) {
            return MCast.tolong((Object)value, (long)0L);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(MCast.tofloat((Object)value, (float)0.0f));
        }
        if (type == Double.TYPE || type == Double.class) {
            return MCast.todouble((Object)value, (double)0.0);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return MCast.toboolean((Object)value, (boolean)false);
        }
        if (type == java.util.Date.class) {
            return MCast.toDate((Object)String.valueOf(value), null);
        }
        if (type == Date.class) {
            java.util.Date data = MCast.toDate((Object)String.valueOf(value), null);
            if (data == null) {
                return null;
            }
            return new Date(data.getTime());
        }
        if (type == UUID.class) {
            return UUID.fromString(String.valueOf(value));
        }
        if (type.isEnum()) {
            return String.valueOf(value);
        }
        return null;
    }

    public static List<Object> getObjects(DbManagerService service, Class<?> type, String id) throws MException {
        LinkedList<Object> out = new LinkedList<Object>();
        if (MString.isEmptyTrim((String)id)) {
            return out;
        }
        if (id.startsWith("(") && id.endsWith(")")) {
            String aql = id.substring(1, id.length() - 1);
            for (Object o : service.getManager().getByQualification(type, aql, null)) {
                out.add(o);
            }
        } else {
            Object obj = service.getManager().getObject(type, new Object[]{id});
            if (obj != null) {
                out.add(obj);
            }
        }
        return out;
    }
}

