/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.karaf.MOsgi;
import de.mhus.lib.karaf.ReferenceInject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class MServiceTracker<T> {
    private BundleContext context;
    protected Class<T> clazz;
    private ServiceTrackerCustomizer<T, T> customizer = new ServiceTrackerCustomizer<T, T>(){

        public T addingService(ServiceReference<T> reference) {
            Object service = MServiceTracker.this.context.getService(reference);
            if (service != null && service instanceof ReferenceInject) {
                ((ReferenceInject)service).setReference(reference);
            }
            MServiceTracker.this.addService(reference, service);
            return service;
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
            if (service != null && service instanceof ReferenceInject) {
                ((ReferenceInject)service).setReference(reference);
            }
            MServiceTracker.this.modifyService(reference, service);
        }

        public void removedService(ServiceReference<T> reference, T service) {
            MServiceTracker.this.removeService(reference, service);
        }
    };
    private ServiceTracker<T, T> tracker;

    public MServiceTracker(Class<T> clazz) {
        this(null, clazz);
    }

    protected void modifyService(ServiceReference<T> reference, T service) {
        this.removeService(reference, service);
        this.addService(reference, service);
    }

    protected abstract void removeService(ServiceReference<T> var1, T var2);

    protected abstract void addService(ServiceReference<T> var1, T var2);

    public MServiceTracker(BundleContext context, Class<T> clazz) {
        if (context == null) {
            context = MOsgi.getBundleContext();
        }
        this.context = context;
        this.clazz = clazz;
    }

    public MServiceTracker<T> start() {
        if (this.tracker != null) {
            return this;
        }
        this.tracker = new ServiceTracker(this.context, this.clazz, this.customizer);
        this.tracker.open(true);
        return this;
    }

    public void stop() {
        if (this.tracker == null) {
            return;
        }
        this.tracker.close();
        this.tracker = null;
    }

    public boolean isRunning() {
        return this.tracker != null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
    }
}

