/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.base.service.TimerFactory;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.base.service.TimerImpl;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.Version;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.lib.errors.NotFoundRuntimeException;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class MOsgi {
    public static final String COMPONENT_NAME = "component.name";
    private static final Log log = Log.getLog(MOsgi.class);
    private static Timer localTimer;

    public static <T> T getService(Class<T> ifc) throws NotFoundException {
        BundleContext context = FrameworkUtil.getBundle(ifc).getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(MOsgi.class).getBundleContext();
        }
        if (context == null) {
            throw new NotFoundException(new Object[]{"service context not found", ifc});
        }
        ServiceReference ref = context.getServiceReference(ifc);
        if (ref == null) {
            throw new NotFoundException(new Object[]{"service reference not found", ifc});
        }
        Object obj = context.getService(ref);
        if (obj == null) {
            throw new NotFoundException(new Object[]{"service not found", ifc});
        }
        return (T)obj;
    }

    public static <T> T getService(Class<T> ifc, String filter) throws NotFoundException {
        List<T> list = MOsgi.getServices(ifc, filter);
        if (list.size() == 0) {
            throw new NotFoundException(new Object[]{"service not found", ifc, filter});
        }
        return list.get(0);
    }

    public static <T> List<T> getServices(Class<T> ifc, String filter) {
        BundleContext context = FrameworkUtil.getBundle(ifc).getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(MOsgi.class).getBundleContext();
        }
        if (context == null) {
            throw new NotFoundRuntimeException(new Object[]{"service context not found", ifc});
        }
        LinkedList<Object> out = new LinkedList<Object>();
        try {
            for (ServiceReference ref : context.getServiceReferences(ifc, filter)) {
                Object obj = context.getService(ref);
                out.add(obj);
            }
        }
        catch (Exception e) {
            log.d(new Object[]{ifc, filter, e});
        }
        return out;
    }

    public static <T> List<Service<T>> getServiceRefs(Class<T> ifc, String filter) {
        BundleContext context = FrameworkUtil.getBundle(ifc).getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(MOsgi.class).getBundleContext();
        }
        if (context == null) {
            throw new NotFoundRuntimeException(new Object[]{"service context not found", ifc});
        }
        LinkedList<Service<T>> out = new LinkedList<Service<T>>();
        try {
            for (ServiceReference ref : context.getServiceReferences(ifc, filter)) {
                out.add(new Service(ref, context));
            }
        }
        catch (Exception e) {
            log.d(new Object[]{ifc, filter, e});
        }
        return out;
    }

    public static synchronized TimerIfc getTimer() {
        TimerIfc timer = null;
        try {
            timer = MOsgi.getService(TimerFactory.class).getTimer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (timer == null) {
            if (localTimer == null) {
                localTimer = new Timer("de.mhu.lib.localtimer", true);
            }
            timer = new TimerImpl(localTimer);
        }
        return timer;
    }

    public static String filterServiceId(String name) {
        return "(service.id=" + name + ")";
    }

    public static String filterServiceName(String name) {
        return "(component.name=" + name + ")";
    }

    public static String filterObjectClass(String clazz) {
        return "(objectClass=" + clazz + ")";
    }

    public static String filterAdd(String ... parts) {
        StringBuilder out = new StringBuilder().append("(&");
        for (String part : parts) {
            out.append(part);
        }
        out.append(")");
        return out.toString();
    }

    public static String getServiceId(ServiceReference<?> ref) {
        if (ref == null) {
            return null;
        }
        return String.valueOf(ref.getProperty("service.id"));
    }

    public static String getServiceName(ServiceReference<?> ref) {
        if (ref == null) {
            return null;
        }
        return String.valueOf(ref.getProperty(COMPONENT_NAME));
    }

    public static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(MOsgi.class).getBundleContext();
    }

    public static BUNDLE_STATE getState(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return BUNDLE_STATE.UNINSTALLED;
            }
            case 2: {
                return BUNDLE_STATE.INSTALLED;
            }
            case 4: {
                return BUNDLE_STATE.RESOLVED;
            }
            case 8: {
                return BUNDLE_STATE.STARTING;
            }
            case 16: {
                return BUNDLE_STATE.STOPPING;
            }
            case 32: {
                return BUNDLE_STATE.ACTIVE;
            }
        }
        return BUNDLE_STATE.UNKNOWN;
    }

    public static Version getBundelVersion(Class<?> owner) {
        Bundle bundle = FrameworkUtil.getBundle(owner);
        if (bundle == null) {
            return Version.V_0_0_0;
        }
        return new Version(bundle.getVersion().toString());
    }

    public static enum BUNDLE_STATE {
        UNINSTALLED,
        INSTALLED,
        RESOLVED,
        STARTING,
        STOPPING,
        ACTIVE,
        UNKNOWN;

    }

    public static class Service<T> {
        private ServiceReference<T> ref;
        private T obj;
        private BundleContext context;

        public Service(ServiceReference<T> ref, BundleContext context) {
            this.ref = ref;
            this.obj = null;
            this.context = context;
        }

        public T getService() {
            if (this.obj == null) {
                this.obj = this.context.getService(this.ref);
            }
            return this.obj;
        }

        public ServiceReference<T> getReference() {
            return this.ref;
        }

        public String getName() {
            return MOsgi.getServiceName(this.ref);
        }
    }
}

