/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DataSourceUtil {
    public static final String SERVICE_JNDI_NAME_KEY = "osgi.jndi.service.name";
    private BundleContext context;

    public DataSourceUtil() {
        this.context = FrameworkUtil.getBundle(DataSourceUtil.class).getBundleContext();
    }

    public DataSourceUtil(BundleContext context) {
        this.context = context;
    }

    public DataSource getDataSource(String name) {
        try {
            Collection refs = this.getContext().getServiceReferences(DataSource.class, "(osgi.jndi.service.name=" + name + ")");
            if (refs.size() > 0) {
                return (DataSource)this.getContext().getService((ServiceReference)refs.iterator().next());
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public ServiceReference<DataSource>[] getDataSources() {
        try {
            ServiceReference[] dsRefs = this.getContext().getServiceReferences(DataSource.class.getName(), null);
            if (dsRefs == null) {
                dsRefs = new ServiceReference[]{};
            }
            return dsRefs;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getServiceJndiName(ServiceReference<?> ref) {
        String jndiName = (String)ref.getProperty(SERVICE_JNDI_NAME_KEY);
        return jndiName;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void registerDataSource(DataSource dataSource, String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(SERVICE_JNDI_NAME_KEY, name);
        ((Dictionary)properties).put("dataSourceName", name);
        this.context.registerService(DataSource.class, (Object)dataSource, properties);
    }
}

