/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.vault.DefaultEntry;
import de.mhus.lib.core.vault.FileVaultSource;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.MVaultUtil;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultSource;
import java.io.File;
import java.util.UUID;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="mhus", name="vault", description="Vault Manipulation")
@Service
public class CmdVault
extends MLog
implements Action {
    private static final long MAX_FILE_LENGTH = 0x100000L;
    @Argument(index=0, name="cmd", required=true, description="Create keys with openssl: openssl genrsa -out private.pem 8192\nCommands:\n sources\n list\n get <id>\n addfile <file> [description]\n addraw <type> <description> <value>\n remove <id>\n save\n load\n addfilesource <file> <passphrase>\n removesource <id>\n encodepasswordrot13 <clear>\n encodepasswordwithkey <key id> <clear>\n decodepassword <encoded password>", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-s", aliases={"--source"}, description="Set vault source name")
    String sourcename = "default";

    public Object execute() throws Exception {
        MVault vault = MVaultUtil.loadDefault();
        if (this.cmd.equals("sources")) {
            ConsoleTable out = new ConsoleTable();
            out.setHeaderValues(new String[]{"Source", "Info"});
            for (String sourceName : vault.getSourceNames()) {
                VaultSource source = vault.getSource(sourceName);
                out.addRowValues(new Object[]{sourceName, source});
            }
            out.print(System.out);
        } else if (this.cmd.equals("list")) {
            if (this.sourcename.equals("default")) {
                ConsoleTable out = new ConsoleTable();
                out.setHeaderValues(new String[]{"Source", "Id", "Type", "Description"});
                for (String sourceName : vault.getSourceNames()) {
                    try {
                        VaultSource source = vault.getSource(sourceName);
                        for (UUID id : source.getEntryIds()) {
                            VaultEntry entry = source.getEntry(id);
                            out.addRowValues(new Object[]{sourceName, id, entry.getType(), entry.getDescription()});
                        }
                    }
                    catch (Throwable t) {
                        this.log().d(new Object[]{sourceName, t});
                    }
                }
                out.print(System.out);
            } else {
                VaultSource source = vault.getSource(this.sourcename);
                if (source == null) {
                    System.out.println("Source not found!");
                    return null;
                }
                ConsoleTable out = new ConsoleTable();
                out.setHeaderValues(new String[]{"Source", "Id", "Type", "Description"});
                for (UUID id : source.getEntryIds()) {
                    VaultEntry entry = source.getEntry(id);
                    out.addRowValues(new Object[]{this.sourcename, id, entry.getType(), entry.getDescription()});
                }
                out.print(System.out);
            }
        } else if (this.cmd.equals("addraw")) {
            VaultSource source = vault.getSource(this.sourcename);
            if (source == null) {
                System.out.println("Source not found!");
                return null;
            }
            MutableVaultSource mutable = (MutableVaultSource)source.adaptTo(MutableVaultSource.class);
            String type = this.parameters[0];
            String description = this.parameters[1];
            String value = this.parameters[2];
            DefaultEntry entry = new DefaultEntry(type, description, value);
            mutable.addEntry((VaultEntry)entry);
            System.out.println("Created " + entry + ". Don't forget to save!");
        } else if (this.cmd.equals("addfile")) {
            VaultSource source = vault.getSource(this.sourcename);
            if (source == null) {
                System.out.println("Source not found!");
                return null;
            }
            MutableVaultSource mutable = (MutableVaultSource)source.adaptTo(MutableVaultSource.class);
            File file = new File(this.parameters[0]);
            if (!file.exists()) {
                System.out.println("File not found");
                return null;
            }
            if (!file.isFile()) {
                System.out.println("File is not an file");
                return null;
            }
            if (file.length() > 0x100000L) {
                System.out.println("File to large to load");
                return null;
            }
            String content = MFile.readFile((File)file);
            String desc = (this.parameters.length > 1 ? this.parameters[1] + ";" : "") + file.getName();
            DefaultEntry entry = null;
            entry = content.contains("-----BEGIN RSA PRIVATE KEY-----") ? new DefaultEntry("rsa.cipher.private.key", desc, content) : (content.contains("-----BEGIN RSA PUBLIC KEY-----") ? new DefaultEntry("rsa.cipher.public.key", desc, content) : new DefaultEntry("text", desc, content));
            mutable.addEntry((VaultEntry)entry);
            System.out.println("Create " + entry.getId() + " " + entry.getType() + ". Don't forget to save!");
        } else if (this.cmd.equals("save")) {
            VaultSource source = vault.getSource(this.sourcename);
            if (source == null) {
                System.out.println("Source not found!");
                return null;
            }
            MutableVaultSource mutable = (MutableVaultSource)source.adaptTo(MutableVaultSource.class);
            mutable.doSave();
            System.out.println("OK");
        } else if (this.cmd.equals("load")) {
            VaultSource source = vault.getSource(this.sourcename);
            if (source == null) {
                System.out.println("Source not found!");
                return null;
            }
            MutableVaultSource mutable = (MutableVaultSource)source.adaptTo(MutableVaultSource.class);
            mutable.doLoad();
            System.out.println("OK");
        } else if (this.cmd.equals("get")) {
            VaultEntry entry = vault.getEntry(UUID.fromString(this.parameters[0]));
            if (entry == null) {
                System.out.println("Entry not found");
                return null;
            }
            System.out.println("Id         : " + entry.getId());
            System.out.println("Type       : " + entry.getType());
            System.out.println("Description: " + entry.getDescription());
            System.out.println(" Value");
            System.out.println("-------");
            System.out.println(entry.getValue());
            System.out.println("-------");
        } else if (this.cmd.equals("remove")) {
            VaultSource source = vault.getSource(this.sourcename);
            if (source == null) {
                System.out.println("Source not found!");
                return null;
            }
            MutableVaultSource mutable = (MutableVaultSource)source.adaptTo(MutableVaultSource.class);
            mutable.removeEntry(UUID.fromString(this.parameters[0]));
            System.out.println("OK");
        } else if (this.cmd.equals("addfilesource")) {
            FileVaultSource source = new FileVaultSource(new File(this.parameters[0]), this.parameters[1]);
            vault.registerSource((VaultSource)source);
            System.out.println("Registered " + source);
        } else if (this.cmd.equals("removesource")) {
            vault.unregisterSource(this.parameters[0]);
            System.out.println("OK");
        } else if (this.cmd.equals("encodepasswordrot13")) {
            System.out.println(MPassword.encode((int)1, (String)this.parameters[0], null));
        }
        if (this.cmd.equals("encodepasswordwithkey")) {
            System.out.println(MPassword.encode((int)2, (String)this.parameters[1], (String)this.parameters[0]));
        } else if (this.cmd.equals("decodepassword")) {
            System.out.println(MPassword.decode((String)this.parameters[0]));
        }
        return null;
    }
}

