/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.karaf.util.OsgiBundleClassLoader;
import de.mhus.lib.sql.analytics.SqlAnalytics;
import de.mhus.lib.sql.analytics.SqlAnalyzer;
import de.mhus.lib.sql.analytics.SqlReporter;
import de.mhus.lib.sql.analytics.SqlRuntimeAnalyzer;
import de.mhus.lib.sql.analytics.SqlRuntimeWarning;
import de.mhus.lib.sql.analytics.SqlRuntimeWriter;
import java.util.Collection;
import java.util.Comparator;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="mhus", name="sql", description="Sql tooling")
@Service
public class CmdSql
extends MLog
implements Action {
    @Reference
    private Session session;
    @Argument(index=0, name="cmd", required=true, description="Command:\n set - sets analytics tool ,\n reset - remove analytics tool,\n list - print analysis data,\n", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-f", aliases={"--full"}, description="Full table output", required=false)
    protected boolean full;

    public Object execute() throws Exception {
        switch (this.cmd) {
            case "set": {
                SqlRuntimeAnalyzer analyzer = null;
                if (this.parameters == null || this.parameters[0].equals("analyzer")) {
                    analyzer = new SqlRuntimeAnalyzer();
                } else if (this.parameters[0].equals("writer")) {
                    analyzer = new SqlRuntimeWriter();
                } else if (this.parameters[0].equals("warning")) {
                    analyzer = new SqlRuntimeWarning();
                } else if (this.parameters[0].equals("reporter")) {
                    analyzer = new SqlReporter();
                } else {
                    OsgiBundleClassLoader loader = new OsgiBundleClassLoader();
                    analyzer = (SqlAnalyzer)loader.loadClass(this.parameters[0]).newInstance();
                }
                SqlAnalytics.setAnalyzer((SqlAnalyzer)analyzer);
                System.out.println(analyzer);
                break;
            }
            case "reset": {
                SqlAnalytics.setAnalyzer(null);
                System.out.println("OK");
                break;
            }
            case "list": {
                SqlAnalyzer analyzer = SqlAnalytics.getAnalyzer();
                if (analyzer instanceof SqlRuntimeAnalyzer) {
                    Collection data = ((SqlRuntimeAnalyzer)analyzer).getData();
                    ConsoleTable table = new ConsoleTable(this.full);
                    table.setHeaderValues(new String[]{"Count", "Runtime", "R/C", "Sql"});
                    for (SqlRuntimeAnalyzer.Container d : data) {
                        table.addRowValues(new Object[]{d.getCnt(), d.getRuntime(), d.getRuntime() / (long)d.getCnt(), d.getSql()});
                    }
                    table.sort(2, (Comparator)new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return -Integer.compare(M.c((Object)o1, (int)0), M.c((Object)o2, (int)0));
                        }
                    });
                    table.print(System.out);
                    break;
                }
                System.out.println(analyzer);
                break;
            }
            default: {
                System.out.println("Unknown cmd");
            }
        }
        return null;
    }
}

