/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.console.ANSIConsole;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.io.TailInputStream;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.core.util.lambda.LambdaUtil;
import de.mhus.lib.logging.level.GeneralMapper;
import de.mhus.lib.logging.level.ThreadBasedMapper;
import de.mhus.lib.logging.level.ThreadMapperConfig;
import de.mhus.lib.mutable.KarafMApiImpl;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="mhus", name="log", description="Manipulate Log behavior.")
@Service
public class CmdLog
extends MLog
implements Action {
    @Reference
    private Session session;
    @Argument(index=0, name="cmd", required=true, description="Command:\n clear - reset all loggers,\n add <path> - add a trace log,\n full - enable full trace logging,\n dirty - enable dirty logging,\n level - set log level (console logger),\n reloadconfig,\n settrail [<config>] - enable trail logging for this thread,\n istrail - output the traillog config,\n releasetrail - unset the current trail log config\n resetalltrail - unset all trail log configs\n general - enable general logging\n off - log mapping off\n trace,debug,info,warn,error,fatal <msg>\nconsole [console=ansi] [file=data/log/karaf.log] [color=true]\n maxmsgsize [new size] - show or set maximum message size, disable with 0\n lambdadebug [true|false]", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-m", aliases={"--max"}, description="Maximum log-block size gap before skip", required=false)
    protected int maxDelta = -1;

    public Object execute() throws Exception {
        IApi s = MApi.get();
        if (!(s instanceof KarafMApiImpl)) {
            System.out.println("Karaf MApi not set");
            return null;
        }
        KarafMApiImpl api = (KarafMApiImpl)s;
        switch (this.cmd) {
            case "clear": {
                api.clearTrace();
                api.setFullTrace(false);
                MApi.updateLoggers();
                System.out.println("OK");
                break;
            }
            case "full": {
                api.setFullTrace(MCast.toboolean((Object)(this.parameters.length >= 1 ? this.parameters[0] : "1"), (boolean)false));
                MApi.updateLoggers();
                System.out.println("OK");
                break;
            }
            case "dirty": {
                MApi.setDirtyTrace((boolean)MCast.toboolean((Object)(this.parameters.length >= 1 ? this.parameters[0] : "1"), (boolean)false));
                System.out.println("OK");
                break;
            }
            case "add": {
                for (String p : this.parameters) {
                    api.setTrace(p);
                }
                MApi.updateLoggers();
                System.out.println("OK");
                break;
            }
            case "list": {
                System.out.println("Default Level  : " + api.getLogFactory().getDefaultLevel());
                System.out.println("Trace          : " + api.isFullTrace());
                System.out.println("LogFoctory     : " + api.getLogFactory().getClass().getSimpleName());
                System.out.println("DirtyTrace     : " + MApi.isDirtyTrace());
                LevelMapper lm = api.getLogFactory().getLevelMapper();
                if (lm != null) {
                    System.out.println("LevelMapper    : " + lm.getClass().getSimpleName());
                    if (lm instanceof TrailLevelMapper) {
                        System.out.println("   Configurtion: " + ((TrailLevelMapper)lm).doSerializeTrail());
                    }
                }
                if (api.getLogFactory().getParameterMapper() != null) {
                    System.out.println("ParameterMapper: " + api.getLogFactory().getParameterMapper().getClass().getSimpleName());
                }
                for (String name : api.getTraceNames()) {
                    System.out.println(name);
                }
                break;
            }
            case "reloadconfig": {
                api.getCfgManager().reConfigure();
                MApi.updateLoggers();
                System.out.println("OK");
                break;
            }
            case "level": {
                api.getLogFactory().setDefaultLevel(Log.LEVEL.valueOf((String)this.parameters[0].toUpperCase()));
                MApi.updateLoggers();
                System.out.println("OK");
                break;
            }
            case "settrail": {
                LevelMapper mapper = api.getLogFactory().getLevelMapper();
                if (MLogUtil.isTrailLevelMapper()) {
                    MLogUtil.setTrailConfig((String)(this.parameters == null || this.parameters.length < 1 ? "" : this.parameters[0]));
                    System.out.println("Trail Config: " + MLogUtil.getTrailConfig());
                    break;
                }
                System.out.println("Wrong Mapper " + mapper);
                break;
            }
            case "istrail": {
                LevelMapper mapper = api.getLogFactory().getLevelMapper();
                if (MLogUtil.isTrailLevelMapper()) {
                    System.out.println("LevelMapper: " + MLogUtil.getTrailConfig());
                    break;
                }
                System.out.println("Wrong Mapper " + mapper);
                break;
            }
            case "releasetrail": {
                LevelMapper mapper = api.getLogFactory().getLevelMapper();
                if (MLogUtil.isTrailLevelMapper()) {
                    MLogUtil.releaseTrailConfig();
                    System.out.println("OK");
                    break;
                }
                System.out.println("Wrong Mapper " + mapper);
                break;
            }
            case "resetalltrail": {
                LevelMapper mapper = api.getLogFactory().getLevelMapper();
                if (MLogUtil.isTrailLevelMapper()) {
                    MLogUtil.resetAllTrailConfigs();
                    System.out.println("OK");
                    break;
                }
                System.out.println("Wrong Mapper " + mapper);
                break;
            }
            case "maxmsgsize": {
                if (this.parameters != null && this.parameters.length > 0) {
                    api.getLogFactory().setMaxMessageSize(MCast.toint((Object)this.parameters[0], (int)0));
                    break;
                }
                System.out.println("Max Message Size: " + api.getLogFactory().getMaxMessageSize());
                break;
            }
            case "general": {
                ThreadMapperConfig config = new ThreadMapperConfig();
                config.doConfigure(this.parameters == null || this.parameters.length < 1 ? "" : this.parameters[0]);
                GeneralMapper mapper = new GeneralMapper();
                mapper.setConfig(config);
                api.getLogFactory().setLevelMapper((LevelMapper)mapper);
                System.out.println("Sel Global Mapper: OK " + api.getLogFactory().getLevelMapper() + " " + config.getTrailId());
                break;
            }
            case "trail": {
                api.getLogFactory().setLevelMapper((LevelMapper)new ThreadBasedMapper());
                System.out.println("Set Trail Mapper OK " + api.getLogFactory().getLevelMapper());
                break;
            }
            case "off": {
                api.getLogFactory().setLevelMapper(null);
                System.out.println("Remove Mapper OK " + api.getLogFactory().getLevelMapper());
                break;
            }
            case "trace": {
                this.log().t((Object[])this.parameters);
                break;
            }
            case "debug": {
                this.log().d((Object[])this.parameters);
                break;
            }
            case "info": {
                this.log().i((Object[])this.parameters);
                break;
            }
            case "warn": {
                this.log().w((Object[])this.parameters);
                break;
            }
            case "error": {
                this.log().e((Object[])this.parameters);
                break;
            }
            case "fatal": {
                this.log().f((Object[])this.parameters);
                break;
            }
            case "console": {
                MProperties pe = new MProperties(this.parameters);
                MThread a = (MThread)this.session.get("__log_tail");
                if (a != null) {
                    a.interupt();
                    this.session.put("__log_tail", null);
                    break;
                }
                PrintStream sConsole = this.session.getConsole();
                if (sConsole == null || this.session.getTerminal() == null) {
                    return null;
                }
                ANSIConsole os = pe.getString("console", "ansi").equals("ansi") ? new ANSIConsole(System.in, sConsole) : new SimpleConsole(System.in, sConsole);
                Session finalSession = this.session;
                File file = new File(pe.getString("file", "data/log/karaf.log"));
                boolean color = pe.getBoolean("color", true);
                MThread appender = new MThread(new Runnable((Console)os, file, finalSession, color){
                    final /* synthetic */ Console val$os;
                    final /* synthetic */ File val$file;
                    final /* synthetic */ Session val$finalSession;
                    final /* synthetic */ boolean val$color;
                    {
                        this.val$os = console;
                        this.val$file = file;
                        this.val$finalSession = session;
                        this.val$color = bl;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$os.println("Log Listen");
                            this.val$os.flush();
                            TailInputStream tail = new TailInputStream(this.val$file);
                            StringBuilder buf = new StringBuilder();
                            boolean niceMode = false;
                            Field runningField = this.val$finalSession.getClass().getDeclaredField("running");
                            if (!runningField.isAccessible()) {
                                runningField.setAccessible(true);
                            }
                            try {
                                while (true) {
                                    boolean running;
                                    if (CmdLog.this.maxDelta > 0 && tail.available() > CmdLog.this.maxDelta) {
                                        MThread.sleep((long)200L);
                                        this.val$os.cleanup();
                                        this.val$os.println("--- Skip Log ---");
                                        this.val$os.flush();
                                        tail.clean();
                                    }
                                    int i = tail.read();
                                    if (!Thread.currentThread().isInterrupted() && (running = ((Boolean)runningField.get(this.val$finalSession)).booleanValue())) {
                                        if (i < 0) continue;
                                        char c = (char)i;
                                        this.val$os.print(c);
                                        if (c == '\n') {
                                            if (niceMode) {
                                                this.val$os.cleanup();
                                            }
                                            niceMode = false;
                                            buf.setLength(0);
                                        } else if (!niceMode && buf.length() < 40) {
                                            buf.append(c);
                                            if (this.val$color && c == '|') {
                                                String m = buf.toString();
                                                if (m.endsWith("| INFO  |")) {
                                                    this.val$os.setColor(Console.COLOR.GREEN, Console.COLOR.UNKNOWN);
                                                    niceMode = true;
                                                } else if (m.endsWith("| ERROR |")) {
                                                    this.val$os.setBold(true);
                                                    this.val$os.setColor(Console.COLOR.RED, Console.COLOR.UNKNOWN);
                                                    niceMode = true;
                                                } else if (m.endsWith("| DEBUG |")) {
                                                    this.val$os.setColor(Console.COLOR.YELLOW, Console.COLOR.UNKNOWN);
                                                    niceMode = true;
                                                } else if (m.endsWith("| WARN  |")) {
                                                    this.val$os.setColor(Console.COLOR.RED, Console.COLOR.UNKNOWN);
                                                    niceMode = true;
                                                } else if (m.endsWith("| FATAL |")) {
                                                    this.val$os.setBlink(true);
                                                    this.val$os.setColor(Console.COLOR.RED, Console.COLOR.UNKNOWN);
                                                    niceMode = true;
                                                }
                                            }
                                        }
                                        this.val$os.flush();
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                CmdLog.this.log().d(new Object[]{t});
                            }
                            CmdLog.this.log().i(new Object[]{"Session Log Closed"});
                            this.val$os.println("Log Closed");
                            tail.close();
                        }
                        catch (Throwable t) {
                            CmdLog.this.log().d(new Object[]{t});
                        }
                    }
                });
                appender.start();
                this.session.put("__log_tail", (Object)appender);
                break;
            }
            case "lambdadebug": {
                LambdaUtil.debugOut = MCast.toboolean((Object)this.parameters[0], (boolean)false);
                System.out.println("OK");
                break;
            }
            default: {
                System.out.println("Unknown cmd");
            }
        }
        return null;
    }
}

