/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgValue;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.mutable.KarafMApiImpl;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="mhus", name="config", description="Manipulate Configuration Values")
@Service
public class CmdConfig
extends MLog
implements Action {
    @Reference
    private Session session;
    @Argument(index=0, name="cmd", required=true, description="Command:\n list\n set <owner> <path> <value>\n restart", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;

    public Object execute() throws Exception {
        IApi s = MApi.get();
        if (!(s instanceof KarafMApiImpl)) {
            System.out.println("Karaf MApi not set");
            return null;
        }
        block5 : switch (this.cmd) {
            case "restart": {
                MApi.get().getCfgManager().reConfigure();
                break;
            }
            case "list": {
                ConsoleTable out = new ConsoleTable();
                out.setHeaderValues(new String[]{"Owner", "Path", "Value", "Default"});
                for (CfgValue value : MApi.getCfgUpdater().getList()) {
                    out.addRowValues(new Object[]{value.getOwner(), value.getPath(), value.value(), value.getDefault()});
                }
                out.print(System.out);
                break;
            }
            case "set": {
                for (CfgValue value : MApi.getCfgUpdater().getList()) {
                    if (!value.getOwner().equals(this.parameters[0]) || !value.getPath().equals(this.parameters[1])) continue;
                    value.setValue(this.parameters[2]);
                    System.out.println("OK");
                    break block5;
                }
                break;
            }
        }
        return null;
    }
}

