/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.mutable;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.service.ConfigProvider;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.SingletonInitialize;
import de.mhus.lib.logging.JavaLoggerFactory;
import java.io.File;
import java.util.Dictionary;
import java.util.HashSet;

public class KarafSingletonImpl
implements ISingleton,
SingletonInitialize {
    private static final String CONFIG_FULL_TRACE = "log.full.trace";
    private static final String CONFIG_TRACE = "log.trace.";
    private static final String CONFIG_DIRTY_TRACE = "log.dirty.trace";
    private static final String CONFIG_FILE_NAME = "config.file.name";
    private JavaLoggerFactory logFactory;
    private File baseDir;
    private IConfig config;
    private BaseControl baseControl;
    private ConfigProvider configProvider;
    private boolean fullTrace = false;
    private HashSet<String> logTrace = new HashSet();
    private String configFileName = "mhus-config.xml";

    public Log createLog(Object owner) {
        String name = null;
        name = owner == null ? "?" : (owner instanceof Class ? ((Class)owner).getName() : owner.getClass().getName());
        return this.logFactory.getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfig getConfig() {
        KarafSingletonImpl karafSingletonImpl = this;
        synchronized (karafSingletonImpl) {
            if (this.config == null) {
                block9: {
                    String configFile = System.getProperty("mhus.config.file", this.configFileName);
                    File file = new File(this.baseDir, configFile);
                    if (MSingleton.isDirtyTrace()) {
                        System.out.println("--- Try to load mhus config from " + file.getAbsolutePath());
                    }
                    if (file.exists() && file.isFile()) {
                        try {
                            this.config = new XmlConfigFile(file);
                        }
                        catch (Exception e) {
                            if (!this.fullTrace) break block9;
                            e.printStackTrace();
                        }
                    }
                }
                if (this.config == null) {
                    this.config = new HashConfig();
                }
            }
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfig() {
        KarafSingletonImpl karafSingletonImpl = this;
        synchronized (karafSingletonImpl) {
            this.config = null;
            this.getConfig();
        }
    }

    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    public MActivator createActivator() {
        return new ActivatorImpl();
    }

    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    public synchronized ConfigProvider getConfigProvider() {
        if (this.configProvider == null) {
            this.configProvider = new ConfigProvider(this.getConfig());
        }
        return this.configProvider;
    }

    public void doInitialize(ClassLoader coreLoader) {
        this.logFactory = new JavaLoggerFactory();
        this.baseDir = new File(".");
    }

    public boolean isTrace(String name) {
        return this.fullTrace || this.logTrace.contains(name);
    }

    public void setFullTrace(boolean trace) {
        this.fullTrace = trace;
    }

    public void setTrace(String name) {
        this.logTrace.add(name);
    }

    public void clearTrace() {
        this.logTrace.clear();
    }

    public String[] getTraceNames() {
        return this.logTrace.toArray(new String[this.logTrace.size()]);
    }

    public boolean isFullTrace() {
        return this.fullTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOsgiConfig(Dictionary<String, ?> config) {
        KarafSingletonImpl karafSingletonImpl = this;
        synchronized (karafSingletonImpl) {
            MProperties p = new MProperties(config);
            this.setFullTrace(p.getBoolean(CONFIG_FULL_TRACE, this.isFullTrace()));
            MSingleton.setDirtyTrace((boolean)p.getBoolean(CONFIG_DIRTY_TRACE, this.isFullTrace()));
            this.clearTrace();
            for (String name : p.keys()) {
                if (!name.startsWith(CONFIG_TRACE) || !p.getBoolean(name, false)) continue;
                this.setTrace(name.substring(CONFIG_TRACE.length() + 1));
            }
            this.configFileName = p.getString(CONFIG_FILE_NAME, this.configFileName);
            this.reloadConfig();
        }
    }
}

