/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.jms;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import de.mhus.lib.jms.JmsConnection;
import de.mhus.lib.karaf.jms.JmsDataSource;
import de.mhus.lib.karaf.jms.JmsManagerService;
import java.util.HashMap;
import javax.jms.JMSException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(name="JmsManagerService", immediate=true)
public class JmsManagerServiceImpl
implements JmsManagerService {
    private HashMap<String, JmsConnection> connections = new HashMap();
    private ServiceTracker<JmsDataSource, JmsDataSource> tracker;
    private BundleContext context;

    @Activate
    public void doActivate(ComponentContext ctx) {
        this.context = ctx.getBundleContext();
        this.tracker = new ServiceTracker(this.context, JmsDataSource.class, (ServiceTrackerCustomizer)new MyServiceTrackerCustomizer());
        this.tracker.open();
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        this.tracker.close();
        for (String name : this.listConnections()) {
            this.removeConnection(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(String name, JmsConnection con) {
        JmsManagerServiceImpl jmsManagerServiceImpl = this;
        synchronized (jmsManagerServiceImpl) {
            this.connections.put(name, con);
        }
    }

    @Override
    public void addConnection(String name, String url, String user, String password) throws JMSException {
        this.addConnection(name, new JmsConnection(url, user, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listConnections() {
        JmsManagerServiceImpl jmsManagerServiceImpl = this;
        synchronized (jmsManagerServiceImpl) {
            return this.connections.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsConnection getConnection(String name) {
        JmsManagerServiceImpl jmsManagerServiceImpl = this;
        synchronized (jmsManagerServiceImpl) {
            return this.connections.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(String name) {
        JmsManagerServiceImpl jmsManagerServiceImpl = this;
        synchronized (jmsManagerServiceImpl) {
            JmsConnection old = this.connections.remove(name);
            if (old != null) {
                old.close();
            }
        }
    }

    private class MyServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<JmsDataSource, JmsDataSource> {
        private MyServiceTrackerCustomizer() {
        }

        public JmsDataSource addingService(ServiceReference<JmsDataSource> reference) {
            JmsDataSource service = (JmsDataSource)JmsManagerServiceImpl.this.context.getService(reference);
            try {
                JmsManagerServiceImpl.this.addConnection(service.getName(), service.createConnection());
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            return service;
        }

        public void modifiedService(ServiceReference<JmsDataSource> reference, JmsDataSource service) {
            JmsManagerServiceImpl.this.removeConnection(service.getName());
            try {
                JmsManagerServiceImpl.this.addConnection(service.getName(), service.createConnection());
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }

        public void removedService(ServiceReference<JmsDataSource> reference, JmsDataSource service) {
            JmsManagerServiceImpl.this.removeConnection(service.getName());
        }
    }
}

