/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.Persistable;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.core.MString;
import de.mhus.lib.karaf.adb.AdbUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.osgi.framework.BundleContext;

@Command(scope="adb", name="count", description="Select data from ADB DataSource ant print the count of found objects")
public class CmdCount
implements Action {
    private BundleContext context;
    @Argument(index=0, name="service", required=true, description="Service Class", multiValued=false)
    String serviceName;
    @Argument(index=1, name="type", required=true, description="Type to select", multiValued=false)
    String typeName;
    @Argument(index=2, name="qualification", required=false, description="Select qualification", multiValued=false)
    String qualification;
    @Argument(index=3, name="attributes", required=false, description="Attributes for the select, e.g user=alfons", multiValued=true)
    String[] attributes;
    @Option(name="-f", aliases={"--full"}, description="Print the full value content also if it's very long", required=false)
    boolean full = false;
    @Option(name="-m", aliases={"--max"}, description="Maximum amount of chars for a value (if not full)", required=false)
    int max = 40;
    @Option(name="-x", description="Output parameter", required=false)
    String outputParam = null;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        DbManagerService service = AdbUtil.getService(this.context, this.serviceName);
        Class<? extends Persistable> type = AdbUtil.getType(service, this.typeName);
        HashMap<String, String> attrObj = null;
        if (this.attributes != null) {
            attrObj = new HashMap<String, String>();
            for (String item : this.attributes) {
                String key = MString.beforeIndex((String)item, (char)'=').trim();
                String value = MString.afterIndex((String)item, (char)'=').trim();
                attrObj.put(key, value);
            }
        }
        String regName = service.getManager().getRegistryName(type);
        Table tableInfo = service.getManager().getTable(regName);
        List pkeys = tableInfo.getPrimaryKeys();
        HashSet<String> pkNames = new HashSet<String>();
        for (Field f : pkeys) {
            pkNames.add(f.getName());
        }
        long count = service.getManager().getCountByQualification(type, this.qualification, attrObj);
        System.out.println(count);
        if (this.outputParam != null) {
            session.put(this.outputParam, (Object)count);
        }
        return null;
    }
}

