/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.mutable.KarafSingletonImpl;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;

@Command(scope="mhus", name="log", description="Manipulate Log behavior.")
public class CmdLog
implements Action {
    @Argument(index=0, name="cmd", required=true, description="Command clear,add,full,dirty,level,reloadconfig", multiValued=false)
    String cmd;
    @Argument(index=1, name="paramteters", required=false, description="Parameters", multiValued=true)
    String[] parameters;

    public Object execute(CommandSession session) throws Exception {
        ISingleton s = MSingleton.get();
        if (!(s instanceof KarafSingletonImpl)) {
            System.out.println("Karaf Singleton not set");
            return null;
        }
        KarafSingletonImpl singleton = (KarafSingletonImpl)s;
        switch (this.cmd) {
            case "clear": {
                singleton.clearTrace();
                singleton.setFullTrace(false);
                singleton.getLogFactory().updateLoggers();
                System.out.println("OK");
                break;
            }
            case "full": {
                singleton.setFullTrace(MCast.toboolean((Object)(this.parameters.length > 1 ? this.parameters[0] : "1"), (boolean)false));
                singleton.getLogFactory().updateLoggers();
                System.out.println("OK");
                break;
            }
            case "dirty": {
                MSingleton.setDirtyTrace((boolean)MCast.toboolean((Object)(this.parameters.length > 1 ? this.parameters[0] : "1"), (boolean)false));
                System.out.println("OK");
                break;
            }
            case "add": {
                for (String p : this.parameters) {
                    singleton.setTrace(p);
                }
                singleton.getLogFactory().updateLoggers();
                System.out.println("OK");
                break;
            }
            case "list": {
                System.out.println("Default Level: " + singleton.getLogFactory().getDefaultLevel());
                System.out.println("Trace: " + singleton.isFullTrace());
                for (String name : singleton.getTraceNames()) {
                    System.out.println(name);
                }
                break;
            }
            case "reloadconfig": {
                singleton.reloadConfig();
                singleton.getLogFactory().updateLoggers();
                System.out.println("OK");
                break;
            }
            case "level": {
                singleton.getLogFactory().setDefaultLevel(Log.LEVEL.valueOf((String)this.parameters[0].toUpperCase()));
                singleton.getLogFactory().updateLoggers();
                System.out.println("OK");
            }
        }
        return null;
    }
}

