/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.mutable;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.service.ConfigProvider;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.SingletonInitialize;
import de.mhus.lib.logging.JavaLoggerFactory;
import java.io.File;

public class KarafSingletonImpl
implements ISingleton,
SingletonInitialize {
    private JavaLoggerFactory logFactory;
    private File baseDir;
    private IConfig config;
    private BaseControl baseControl;
    private ConfigProvider configProvider;

    public Log createLog(Object owner) {
        String name = null;
        name = owner == null ? "?" : (owner instanceof Class ? ((Class)owner).getName() : String.valueOf(owner));
        return this.logFactory.getInstance(name);
    }

    public synchronized IConfig getConfig() {
        if (this.config == null) {
            File file = new File(this.baseDir, "config.xml");
            if (file.exists() && file.isFile()) {
                try {
                    this.config = new XmlConfigFile(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.config == null) {
                this.config = new HashConfig();
            }
        }
        return this.config;
    }

    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    public MActivator createActivator() {
        return new ActivatorImpl();
    }

    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    public synchronized ConfigProvider getConfigProvider() {
        if (this.configProvider == null) {
            this.configProvider = new ConfigProvider(this.getConfig());
        }
        return this.configProvider;
    }

    public void doInitialize(ClassLoader coreLoader) {
        this.logFactory = new JavaLoggerFactory();
        this.baseDir = new File(".");
    }

    public boolean isTrace(String name) {
        return false;
    }
}

