/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.karaf.adb.AdbUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import de.mhus.lib.karaf.adb.DbManagerServiceProvider;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;

@Command(scope="adb", name="providers", description="List all ADB Service Providers")
public class CmdListProviders
implements Action {
    private BundleContext context;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        ConsoleTable table = new ConsoleTable();
        table.setHeaderValues(new String[]{"Provider", "Services"});
        for (DbManagerServiceProvider provider : AdbUtil.getServiceProviders(this.context)) {
            StringBuffer types = new StringBuffer();
            for (DbManagerService service : provider.getServices()) {
                if (types.length() != 0) {
                    types.append(',');
                }
                types.append(service.getServiceName());
            }
            table.addRowValues(new String[]{provider.getClass().getSimpleName(), types.toString()});
        }
        table.print(System.out);
        return null;
    }
}

