/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.karaf.adb.AdbUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;

@Command(scope="adb", name="list", description="List all ADB Services")
public class CmdList
implements Action {
    private BundleContext context;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        ConsoleTable table = new ConsoleTable();
        table.setHeaderValues(new String[]{"Nr", "Service", "Schema", "DataSource", "Managed Types"});
        int cnt = 0;
        for (DbManagerService service : AdbUtil.getServices(this.context, false)) {
            if (service.isConnected()) {
                DbManager manager = service.getManager();
                StringBuffer types = new StringBuffer();
                for (Class type : manager.getSchema().getObjectTypes()) {
                    if (types.length() != 0) {
                        types.append(',');
                    }
                    types.append(type.getSimpleName());
                }
                table.addRowValues(new String[]{"*" + cnt, service.getServiceName(), manager.getSchema().getClass().getSimpleName(), service.getDataSourceName(), types.toString()});
            } else {
                table.addRowValues(new String[]{"*" + cnt, service.getServiceName(), "[not connected]", service.getDataSourceName(), ""});
            }
            ++cnt;
        }
        table.print(System.out);
        return null;
    }
}

