/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.core.MString;
import de.mhus.lib.karaf.adb.AdbUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import java.util.HashMap;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.osgi.framework.BundleContext;

@Command(scope="adb", name="clone", description="Load a object out of the database and store it as a clone.")
public class CmdClone
implements Action {
    private BundleContext context;
    @Argument(index=0, name="service", required=true, description="Service Class", multiValued=false)
    String serviceName;
    @Argument(index=1, name="type", required=true, description="Type to select", multiValued=false)
    String typeName;
    @Argument(index=2, name="id", required=true, description="Id of the object to clone or query", multiValued=false)
    String id;
    @Argument(index=3, name="attributes", required=false, description="Attributes for the initial creation", multiValued=true)
    String[] attributes;
    @Option(name="-x", description="Output parameter", required=false)
    String outputParam = null;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        Object output = null;
        DbManagerService service = AdbUtil.getService(this.context, this.serviceName);
        Class<?> type = AdbUtil.getType(service, this.typeName);
        String regName = service.getManager().getRegistryName(type);
        Table tableInfo = service.getManager().getTable(regName);
        for (Object object : AdbUtil.getObjects(service, type, this.id)) {
            System.out.println(">>> CLONE " + object);
            HashMap<String, String> attrObj = null;
            attrObj = new HashMap<String, String>();
            if (this.attributes != null) {
                for (String string : this.attributes) {
                    String key = MString.beforeIndex((String)string, (char)'=').trim();
                    String value = MString.afterIndex((String)string, (char)'=').trim();
                    attrObj.put(key, value);
                }
            }
            for (String string : tableInfo.getFields()) {
                if (!attrObj.containsKey(string.getName())) continue;
                Object v = AdbUtil.createAttribute(string.getType(), attrObj.get(string.getName()));
                System.out.println("--- SET " + string.getName() + "  = " + v);
                string.set(object, v);
            }
            System.out.print("*** CREATE");
            service.getManager().createObject(regName, object);
            for (Field f : tableInfo.getPrimaryKeys()) {
                System.out.print(" ");
                System.out.print(f.get(object));
            }
            output = object;
            System.out.println();
        }
        if (this.outputParam != null) {
            session.put(this.outputParam, output);
        }
        return null;
    }
}

