package de.mhus.lib.karaf.adb;

import javax.sql.DataSource;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.DbSchema;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.errors.MException;
import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.sql.DataSourceProvider;
import de.mhus.lib.sql.DbPool;
import de.mhus.lib.sql.DefaultDbPool;
import de.mhus.lib.sql.Dialect;
//@Component(provide=DbManagerService.class,name="...",immediate=true)
public abstract class DbManagerServiceImpl implements DbManagerService {

	protected BundleContext context;
	protected DataSourceUtil util;
	private String dataSourceName;
	private DbManager manager;
	protected Log log = Log.getLog(this.getClass());

/* Include this in your service
	@Activate
	public void doActivate(ComponentContext ctx) {
		super.doActivate(ctx);
	}

	@Deactivate
	public void doDeactivate(ComponentContext ctx) {
		super.doDeactivate(ctx);
	}
 */
	public void doActivate(ComponentContext ctx) {
		log.i("Activate");
		context = ctx.getBundleContext();
//		try {
//			doOpen();
//		} catch (Exception e) {
//			log.e(e);
//		}
	}
	
	public void doDeactivate(ComponentContext ctx) {
		log.i("Deactivate");
		doClose();
	}
	
	protected abstract void doInitialize() throws Exception;
	
	/**
	 * Call this function in the doActivate() after you set the context and dataSourceName attribute.
	 * @throws Exception 
	 */
	protected void doOpen(boolean clean) throws Exception {
		if (manager != null) return;
		doInitialize();
		util = new DataSourceUtil(context);
		
		if (getDataSource() == null) return;

		manager = doCreateDbManager(clean);
	}
	
	protected void doClose() {
		if (manager == null) return;
		manager.getPool().close();
		manager = null;
	}
	
	protected DbManager doCreateDbManager(boolean clean) throws Exception {
		
		DbPool pool = doCreateDataPool();
		DbSchema schema = doCreateSchema();
		return new DbManager(pool, schema, clean);
	}

	protected abstract DbSchema doCreateSchema();

	protected DbPool doCreateDataPool() {
		return new DefaultDbPool(new DataSourceProvider(getDataSource(), doCreateDialect(), doCreateConfig(), doCreateActivator() ));
	}

	protected MActivator doCreateActivator() {
		try {
			return new ActivatorImpl(null, getClass().getClassLoader());
		} catch (MException e) {
			log.e(e);
		}
		return null;
	}

	protected ResourceNode doCreateConfig() {
		return null;
	}

	protected Dialect doCreateDialect() {
		return null;
	}

	protected DataSource getDataSource() {
		DataSource ds = util.getDataSource(dataSourceName);
		if (ds == null)
			log.w("DataSource is unknown",dataSourceName);
		return ds;
	}
	
	@Override
	public void updateManager(boolean clean) throws Exception {
		doClose();
//		if (!isConnected()) {
			if (getDataSource() == null) return;
			doOpen(clean);
//			return;
//		}
//		((DataSourceProvider)manager.getPool().getProvider()).setDataSource(getDataSource());
	}
	
	@Override
	public DbManager getManager() {
		try {
			doOpen(false);
		} catch (Exception e) {
		}
		return manager;
	}
	
	@Override
	public boolean isConnected() {
		return manager != null;
	}

	@Override
	public String getDataSourceName() {
		return dataSourceName;
	}

	@Override
	public void setDataSourceName(String dataSourceName) {
		if (MSystem.equals(this.dataSourceName, dataSourceName))
			return;
		this.dataSourceName = dataSourceName;
		try {
			updateManager(false);
		} catch (Exception e) {
		}
	}
	
	@Override
	public String getServiceName() {
		return getClass().getSimpleName();
	}

}
